/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.interceptor.registry.InterceptorRegistryAdaptor;
import com.navercorp.pinpoint.profiler.AgentInformation;
import com.navercorp.pinpoint.profiler.context.module.DefaultApplicationContext;
import com.navercorp.pinpoint.profiler.context.storage.LogStorageFactory;
import com.navercorp.pinpoint.profiler.context.storage.StorageFactory;
import com.navercorp.pinpoint.profiler.interceptor.registry.InterceptorRegistryBinder;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import com.navercorp.pinpoint.profiler.sender.LoggingDataSender;
import com.navercorp.pinpoint.test.InterceptorRegistryModule;
import com.navercorp.pinpoint.test.MockApplicationContextFactory;
import com.navercorp.pinpoint.test.OverrideModuleFactory;
import com.navercorp.pinpoint.test.TestAgentInformation;

public class MockTraceContextFactory {
    public static DefaultApplicationContext newMockApplicationContext(ProfilerConfig profilerConfig) {
        LoggingModule loggingModule = new LoggingModule();
        EmptyInterceptorRegistryBinder interceptorRegistryBinder = new EmptyInterceptorRegistryBinder();
        Module interceptorRegistryModule = InterceptorRegistryModule.wrap(interceptorRegistryBinder);
        OverrideModuleFactory moduleFactory = new OverrideModuleFactory(new Module[]{loggingModule, interceptorRegistryModule});
        MockApplicationContextFactory factory = new MockApplicationContextFactory();
        return factory.build(profilerConfig, moduleFactory);
    }

    public static class EmptyInterceptorRegistryBinder
    implements InterceptorRegistryBinder {
        public void bind() {
        }

        public void unbind() {
        }

        public InterceptorRegistryAdaptor getInterceptorRegistryAdaptor() {
            return null;
        }

        public String getInterceptorRegistryClassName() {
            return null;
        }
    }

    public static class LoggingModule
    extends AbstractModule {
        protected void configure() {
            this.bind(AgentInformation.class).toInstance((Object)new TestAgentInformation());
            this.bind(StorageFactory.class).toInstance((Object)new LogStorageFactory());
            this.bind(EnhancedDataSender.class).toInstance((Object)new LoggingDataSender());
        }
    }
}

