/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.cluster;

import com.navercorp.pinpoint.rpc.cluster.Role;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterOption {
    public static final ClusterOption DISABLE_CLUSTER_OPTION = new ClusterOption(false, "", Collections.<Role>emptyList());
    private final boolean enable;
    private final String id;
    private final List<Role> roles;

    public ClusterOption(boolean enable, String id, String role) {
        this(enable, id, Role.getValue(role));
    }

    public ClusterOption(boolean enable, String id, Role role) {
        this(enable, id, Arrays.asList(role));
    }

    public ClusterOption(ClusterOption clusterOption) {
        this(clusterOption.enable, clusterOption.id, new ArrayList<Role>(clusterOption.roles));
    }

    public ClusterOption(boolean enable, String id, List<Role> roles) {
        this.enable = enable;
        this.id = id;
        this.roles = roles;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String getId() {
        return this.id;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public Map<String, Object> toMap() {
        if (!this.enable) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> clusterProperties = new HashMap<String, Object>(2);
        clusterProperties.put("id", this.id);
        ArrayList<String> roleList = new ArrayList<String>(this.roles.size());
        for (Role role : this.roles) {
            roleList.add(role.name());
        }
        clusterProperties.put("roles", roleList);
        return clusterProperties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClusterOption{");
        sb.append("enable=").append(this.enable);
        sb.append(", id='").append(this.id).append('\'');
        sb.append(", roles=").append(this.roles);
        sb.append('}');
        return sb.toString();
    }

    public static ClusterOption copy(ClusterOption clusterOption) {
        return new ClusterOption(clusterOption.enable, clusterOption.id, clusterOption.roles);
    }
}

