/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.hikaricp.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.monitor.DataSourceMonitor;
import com.navercorp.pinpoint.bootstrap.plugin.monitor.DataSourceMonitorRegistry;
import com.navercorp.pinpoint.bootstrap.util.InterceptorUtils;
import com.navercorp.pinpoint.plugin.hikaricp.DataSourceMonitorAccessor;
import com.navercorp.pinpoint.plugin.hikaricp.HikariCpConstants;
import com.navercorp.pinpoint.plugin.hikaricp.HikariCpDataSourceMonitor;
import java.lang.reflect.Method;
import java.util.Properties;

public class DataSourceConstructorInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    private final PLogger logger = PLoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final DataSourceMonitorRegistry dataSourceMonitorRegistry;

    public DataSourceConstructorInterceptor(TraceContext traceContext, MethodDescriptor descriptor, DataSourceMonitorRegistry dataSourceMonitorRegistry) {
        super(traceContext, descriptor);
        this.dataSourceMonitorRegistry = dataSourceMonitorRegistry;
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
    }

    protected void prepareAfterTrace(Object target, Object[] args, Object result, Throwable throwable) {
        if (!InterceptorUtils.isSuccess((Throwable)throwable)) {
            return;
        }
        if (args.length >= 1) {
            try {
                String jdbcUrl = this.getJdbcUrl(args[0]);
                if (jdbcUrl == null) {
                    jdbcUrl = this.findJdbcUrl(args[0]);
                }
                if (jdbcUrl != null) {
                    HikariCpDataSourceMonitor dataSourceMonitor = new HikariCpDataSourceMonitor(target, jdbcUrl);
                    this.dataSourceMonitorRegistry.register((DataSourceMonitor)dataSourceMonitor);
                    if (target instanceof DataSourceMonitorAccessor) {
                        ((DataSourceMonitorAccessor)target)._$PINPOINT$_setDataSourceMonitor(dataSourceMonitor);
                    }
                    this.logger.debug("create HikariCpDataSourceMonitor success. jdbcUrl:{}", (Object)jdbcUrl);
                } else {
                    this.logger.info("failed while creating HikariCpDataSourceMonitor. can't find jdbclUrl");
                }
            }
            catch (Exception e) {
                this.logger.info("failed while creating HikariCpDataSourceMonitor. message:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private String getJdbcUrl(Object object) {
        if (object == null) {
            return null;
        }
        try {
            Method getJdbcUrl = object.getClass().getMethod("getJdbcUrl", new Class[0]);
            if (getJdbcUrl != null) {
                Object result = getJdbcUrl.invoke(object, new Object[0]);
                if (result instanceof String) {
                    return (String)result;
                }
                return null;
            }
        }
        catch (Exception e) {
            this.logger.info("failed while executing getJdbcUrl(). message:{}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    private String findJdbcUrl(Object object) {
        if (object == null) {
            return null;
        }
        try {
            Method getDataSourceProperties = object.getClass().getMethod("getDataSourceProperties", new Class[0]);
            if (getDataSourceProperties != null) {
                Object result = getDataSourceProperties.invoke(object, new Object[0]);
                if (result instanceof Properties) {
                    return ((Properties)result).getProperty("url");
                }
                return null;
            }
        }
        catch (Exception e) {
            this.logger.info("failed while executing getJdbcUrl(). message:{}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        recorder.recordServiceType(HikariCpConstants.SERVICE_TYPE);
        recorder.recordApi(this.getMethodDescriptor());
        recorder.recordException(throwable);
    }
}

