/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.kafka.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.kafka.field.accessor.RemoteAddressFieldAccessor;
import org.apache.kafka.clients.consumer.ConsumerRecords;

public class ConsumerPollInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;

    public ConsumerPollInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (!(target instanceof RemoteAddressFieldAccessor)) {
            return;
        }
        String remoteAddress = ((RemoteAddressFieldAccessor)target)._$PINPOINT$_getRemoteAddress();
        if (StringUtils.isEmpty((String)remoteAddress)) {
            remoteAddress = "Unknown";
        }
        if (result instanceof ConsumerRecords) {
            for (Object consumerRecord : (ConsumerRecords)result) {
                if (!(consumerRecord instanceof RemoteAddressFieldAccessor)) continue;
                ((RemoteAddressFieldAccessor)consumerRecord)._$PINPOINT$_setRemoteAddress(remoteAddress);
            }
        }
    }
}

