/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util;

import com.navercorp.pinpoint.bootstrap.context.ServerMetaData;
import com.navercorp.pinpoint.bootstrap.context.ServiceInfo;
import com.navercorp.pinpoint.profiler.AgentInformation;
import com.navercorp.pinpoint.profiler.JvmInformation;
import com.navercorp.pinpoint.profiler.context.ServerMetaDataRegistryService;
import com.navercorp.pinpoint.thrift.dto.TAgentInfo;
import com.navercorp.pinpoint.thrift.dto.TJvmGcType;
import com.navercorp.pinpoint.thrift.dto.TJvmInfo;
import com.navercorp.pinpoint.thrift.dto.TServerMetaData;
import com.navercorp.pinpoint.thrift.dto.TServiceInfo;
import java.util.ArrayList;

public class AgentInfoFactory {
    private final AgentInformation agentInformation;
    private final ServerMetaDataRegistryService serverMetaDataRegistryService;
    private final JvmInformation jvmInformation;

    public AgentInfoFactory(AgentInformation agentInformation, ServerMetaDataRegistryService serverMetaDataRegistryService, JvmInformation jvmInformation) {
        if (agentInformation == null) {
            throw new NullPointerException("agentInformation must not be null");
        }
        if (serverMetaDataRegistryService == null) {
            throw new NullPointerException("serverMetaDataRegistryService must not be null");
        }
        if (jvmInformation == null) {
            throw new NullPointerException("jvmInformation must not be null");
        }
        this.agentInformation = agentInformation;
        this.serverMetaDataRegistryService = serverMetaDataRegistryService;
        this.jvmInformation = jvmInformation;
    }

    public TAgentInfo createAgentInfo() {
        TAgentInfo tAgentInfo = new TAgentInfo();
        tAgentInfo.setIp(this.agentInformation.getHostIp());
        tAgentInfo.setHostname(this.agentInformation.getMachineName());
        tAgentInfo.setPorts("");
        tAgentInfo.setAgentId(this.agentInformation.getAgentId());
        tAgentInfo.setApplicationName(this.agentInformation.getApplicationName());
        tAgentInfo.setContainer(this.agentInformation.isContainer());
        tAgentInfo.setPid(this.agentInformation.getPid());
        tAgentInfo.setStartTimestamp(this.agentInformation.getStartTime());
        tAgentInfo.setServiceType(this.agentInformation.getServerType().getCode());
        tAgentInfo.setVmVersion(this.agentInformation.getJvmVersion());
        tAgentInfo.setAgentVersion("1.8.5");
        TServerMetaData tServerMetaData = this.createTServerMetaData();
        tAgentInfo.setServerMetaData(tServerMetaData);
        TJvmInfo tJvmInfo = this.createTJvmInfo();
        tAgentInfo.setJvmInfo(tJvmInfo);
        return tAgentInfo;
    }

    private TServerMetaData createTServerMetaData() {
        ServerMetaData serverMetaData = this.serverMetaDataRegistryService.getServerMetaData();
        if (serverMetaData == null) {
            return null;
        }
        TServerMetaData tServerMetaData = new TServerMetaData();
        tServerMetaData.setServerInfo(serverMetaData.getServerInfo());
        tServerMetaData.setVmArgs(serverMetaData.getVmArgs());
        ArrayList<TServiceInfo> tServiceInfos = new ArrayList<TServiceInfo>();
        for (ServiceInfo serviceInfo : serverMetaData.getServiceInfos()) {
            TServiceInfo tServiceInfo = new TServiceInfo();
            tServiceInfo.setServiceName(serviceInfo.getServiceName());
            tServiceInfo.setServiceLibs(serviceInfo.getServiceLibs());
            tServiceInfos.add(tServiceInfo);
        }
        tServerMetaData.setServiceInfos(tServiceInfos);
        return tServerMetaData;
    }

    private TJvmInfo createTJvmInfo() {
        TJvmInfo tJvmInfo = new TJvmInfo();
        tJvmInfo.setVmVersion(this.jvmInformation.getJvmVersion());
        TJvmGcType gcType = TJvmGcType.findByValue((int)this.jvmInformation.getGcTypeCode());
        if (gcType == null) {
            gcType = TJvmGcType.UNKNOWN;
        }
        tJvmInfo.setGcType(gcType);
        return tJvmInfo;
    }
}

