/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor;

import com.navercorp.pinpoint.bootstrap.interceptor.ApiIdAwareAroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.ExceptionHandler;

public class ExceptionHandleApiIdAwareAroundInterceptor
implements ApiIdAwareAroundInterceptor {
    private final ApiIdAwareAroundInterceptor delegate;
    private final ExceptionHandler exceptionHandler;

    public ExceptionHandleApiIdAwareAroundInterceptor(ApiIdAwareAroundInterceptor delegate, ExceptionHandler exceptionHandler) {
        if (delegate == null) {
            throw new NullPointerException("delegate must not be null");
        }
        if (exceptionHandler == null) {
            throw new NullPointerException("exceptionHandler must not be null");
        }
        this.delegate = delegate;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void before(Object target, int apiId, Object[] args) {
        try {
            this.delegate.before(target, apiId, args);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleException(t);
        }
    }

    @Override
    public void after(Object target, int apiId, Object[] args, Object result, Throwable throwable) {
        try {
            this.delegate.after(target, apiId, args, result, throwable);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleException(t);
        }
    }
}

