/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.context.AsyncTraceId;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.ParsingResult;
import com.navercorp.pinpoint.bootstrap.context.ServerMetaDataHolder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcContext;
import com.navercorp.pinpoint.common.annotations.InterfaceAudience;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.AgentInformation;
import com.navercorp.pinpoint.profiler.context.AsyncTraceContext;
import com.navercorp.pinpoint.profiler.context.Reference;
import com.navercorp.pinpoint.profiler.context.TraceFactory;
import com.navercorp.pinpoint.profiler.context.id.TraceIdFactory;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.StringMetaDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTraceContext
implements TraceContext {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TraceIdFactory traceIdFactory;
    private final TraceFactory traceFactory;
    private final AsyncTraceContext asyncTraceContext;
    private final AgentInformation agentInformation;
    private final ApiMetaDataService apiMetaDataService;
    private final StringMetaDataService stringMetaDataService;
    private final SqlMetaDataService sqlMetaDataService;
    private final ProfilerConfig profilerConfig;
    private final ServerMetaDataHolder serverMetaDataHolder;
    private final JdbcContext jdbcContext;

    public DefaultTraceContext(ProfilerConfig profilerConfig, AgentInformation agentInformation, TraceIdFactory traceIdFactory, TraceFactory traceFactory, AsyncTraceContext asyncTraceContext, ServerMetaDataHolder serverMetaDataHolder, ApiMetaDataService apiMetaDataService, StringMetaDataService stringMetaDataService, SqlMetaDataService sqlMetaDataService, JdbcContext jdbcContext) {
        this.profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig must not be null");
        this.agentInformation = (AgentInformation)Assert.requireNonNull((Object)agentInformation, (String)"agentInformation must not be null");
        this.serverMetaDataHolder = (ServerMetaDataHolder)Assert.requireNonNull((Object)serverMetaDataHolder, (String)"serverMetaDataHolder must not be null");
        this.traceIdFactory = (TraceIdFactory)Assert.requireNonNull((Object)traceIdFactory, (String)"traceIdFactory must not be null");
        this.traceFactory = (TraceFactory)Assert.requireNonNull((Object)traceFactory, (String)"traceFactory must not be null");
        this.asyncTraceContext = (AsyncTraceContext)Assert.requireNonNull((Object)asyncTraceContext, (String)"asyncTraceContextProvider must not be null");
        this.jdbcContext = (JdbcContext)Assert.requireNonNull((Object)jdbcContext, (String)"jdbcContext must not be null");
        this.apiMetaDataService = (ApiMetaDataService)Assert.requireNonNull((Object)apiMetaDataService, (String)"apiMetaDataService must not be null");
        this.stringMetaDataService = (StringMetaDataService)Assert.requireNonNull((Object)stringMetaDataService, (String)"stringMetaDataService must not be null");
        this.sqlMetaDataService = (SqlMetaDataService)Assert.requireNonNull((Object)sqlMetaDataService, (String)"sqlMetaDataService must not be null");
    }

    public Trace currentTraceObject() {
        return this.traceFactory.currentTraceObject();
    }

    public Trace currentRawTraceObject() {
        return this.traceFactory.currentRawTraceObject();
    }

    public Trace disableSampling() {
        return this.traceFactory.disableSampling();
    }

    public ProfilerConfig getProfilerConfig() {
        return this.profilerConfig;
    }

    public Trace continueTraceObject(TraceId traceId) {
        return this.traceFactory.continueTraceObject(traceId);
    }

    public Trace continueTraceObject(Trace trace) {
        return this.traceFactory.continueTraceObject(trace);
    }

    public Trace newTraceObject() {
        return this.traceFactory.newTraceObject();
    }

    @InterfaceAudience.LimitedPrivate(value={"vert.x"})
    public Trace newAsyncTraceObject() {
        return this.traceFactory.newAsyncTraceObject();
    }

    @InterfaceAudience.LimitedPrivate(value={"vert.x"})
    public Trace continueAsyncTraceObject(TraceId traceId) {
        return this.traceFactory.continueAsyncTraceObject(traceId);
    }

    public Trace continueAsyncTraceObject(AsyncTraceId asyncTraceId, int asyncId, long startTime) {
        Reference<Trace> traceReference = this.asyncTraceContext.continueAsyncTraceObject(asyncTraceId, asyncId, startTime);
        return traceReference.get();
    }

    public Trace removeTraceObject() {
        return this.removeTraceObject(true);
    }

    public Trace removeTraceObject(boolean closeUnsampledTrace) {
        Trace trace = this.traceFactory.removeTraceObject();
        if (closeUnsampledTrace) {
            return this.closeUnsampledTrace(trace);
        }
        return trace;
    }

    private Trace closeUnsampledTrace(Trace trace) {
        if (trace == null) {
            return null;
        }
        if (!trace.canSampled() && !trace.isClosed()) {
            trace.close();
        }
        return trace;
    }

    public String getAgentId() {
        return this.agentInformation.getAgentId();
    }

    public String getApplicationName() {
        return this.agentInformation.getApplicationName();
    }

    public long getAgentStartTime() {
        return this.agentInformation.getStartTime();
    }

    public short getServerTypeCode() {
        return this.agentInformation.getServerType().getCode();
    }

    public String getServerType() {
        return this.agentInformation.getServerType().getDesc();
    }

    public int cacheApi(MethodDescriptor methodDescriptor) {
        return this.apiMetaDataService.cacheApi(methodDescriptor);
    }

    public int cacheString(String value) {
        return this.stringMetaDataService.cacheString(value);
    }

    public TraceId createTraceId(String transactionId, long parentSpanId, long spanId, short flags) {
        if (transactionId == null) {
            throw new NullPointerException("transactionId must not be null");
        }
        return this.traceIdFactory.continueTraceId(transactionId, parentSpanId, spanId, flags);
    }

    public ParsingResult parseSql(String sql) {
        return this.sqlMetaDataService.parseSql(sql);
    }

    public boolean cacheSql(ParsingResult parsingResult) {
        return this.sqlMetaDataService.cacheSql(parsingResult);
    }

    public ServerMetaDataHolder getServerMetaDataHolder() {
        return this.serverMetaDataHolder;
    }

    public int getAsyncId() {
        return this.asyncTraceContext.nextAsyncId();
    }

    public JdbcContext getJdbcContext() {
        return this.jdbcContext;
    }
}

