/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.rpc.MessageListener;
import com.navercorp.pinpoint.rpc.PinpointSocketException;
import com.navercorp.pinpoint.rpc.StateChangeEventListener;
import com.navercorp.pinpoint.rpc.client.ClientChannelFactory;
import com.navercorp.pinpoint.rpc.client.ClientCodecPipelineFactory;
import com.navercorp.pinpoint.rpc.client.ClientOption;
import com.navercorp.pinpoint.rpc.client.Closed;
import com.navercorp.pinpoint.rpc.client.Connection;
import com.navercorp.pinpoint.rpc.client.ConnectionFactory;
import com.navercorp.pinpoint.rpc.client.ConnectionFactoryProvider;
import com.navercorp.pinpoint.rpc.client.DefaultConnectionFactoryProvider;
import com.navercorp.pinpoint.rpc.client.DefaultPinpointClient;
import com.navercorp.pinpoint.rpc.client.DefaultPinpointClientHandlerFactory;
import com.navercorp.pinpoint.rpc.client.DnsSocketAddressProvider;
import com.navercorp.pinpoint.rpc.client.HandshakerFactory;
import com.navercorp.pinpoint.rpc.client.PinpointClient;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import com.navercorp.pinpoint.rpc.client.ReconnectStateClientHandler;
import com.navercorp.pinpoint.rpc.client.SimpleMessageListener;
import com.navercorp.pinpoint.rpc.client.SocketAddressProvider;
import com.navercorp.pinpoint.rpc.client.SocketOption;
import com.navercorp.pinpoint.rpc.client.StaticSocketAddressProvider;
import com.navercorp.pinpoint.rpc.cluster.ClusterOption;
import com.navercorp.pinpoint.rpc.cluster.Role;
import com.navercorp.pinpoint.rpc.stream.DisabledServerStreamChannelMessageListener;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannelMessageListener;
import com.navercorp.pinpoint.rpc.util.LoggerFactorySetup;
import com.navercorp.pinpoint.rpc.util.TimerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPinpointClientFactory
implements PinpointClientFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicInteger socketId = new AtomicInteger(1);
    private final Closed closed = new Closed();
    private final boolean useExternalResource;
    private final ChannelFactory channelFactory;
    private final SocketOption.Builder socketOptionBuilder;
    private Map<String, Object> properties = Collections.emptyMap();
    private final Timer timer;
    private final ConnectionFactoryProvider connectionFactoryProvider;
    private final ClientOption.Builder clientOptionBuilder = new ClientOption.Builder();
    private ClusterOption clusterOption = ClusterOption.DISABLE_CLUSTER_OPTION;
    private MessageListener messageListener = SimpleMessageListener.INSTANCE;
    private List<StateChangeEventListener> stateChangeEventListeners = new ArrayList<StateChangeEventListener>();
    private ServerStreamChannelMessageListener serverStreamChannelMessageListener = DisabledServerStreamChannelMessageListener.INSTANCE;

    public DefaultPinpointClientFactory() {
        this(1, 1);
    }

    public DefaultPinpointClientFactory(ConnectionFactoryProvider connectionFactoryProvider) {
        this(1, 1, connectionFactoryProvider);
    }

    public DefaultPinpointClientFactory(int bossCount, int workerCount) {
        this(bossCount, workerCount, (ConnectionFactoryProvider)new DefaultConnectionFactoryProvider(new ClientCodecPipelineFactory()));
    }

    public DefaultPinpointClientFactory(int bossCount, int workerCount, ConnectionFactoryProvider connectionFactoryProvider) {
        if (bossCount < 1) {
            throw new IllegalArgumentException("bossCount is negative: " + bossCount);
        }
        this.useExternalResource = false;
        this.timer = DefaultPinpointClientFactory.createTimer("Pinpoint-SocketFactory-Timer");
        ClientChannelFactory channelFactory = new ClientChannelFactory();
        this.logger.debug("createBootStrap boss:{}, worker:{}", (Object)bossCount, (Object)workerCount);
        this.channelFactory = channelFactory.createChannelFactory(bossCount, workerCount, this.timer);
        this.socketOptionBuilder = new SocketOption.Builder();
        this.connectionFactoryProvider = (ConnectionFactoryProvider)Assert.requireNonNull((Object)connectionFactoryProvider, (String)"connectionFactoryProvider must not be null");
    }

    private static Timer createTimer(String timerName) {
        HashedWheelTimer timer = TimerFactory.createHashedWheelTimer(timerName, 100L, TimeUnit.MILLISECONDS, 512);
        timer.start();
        return timer;
    }

    public DefaultPinpointClientFactory(ChannelFactory channelFactory, Timer timer) {
        this(channelFactory, timer, (ConnectionFactoryProvider)new DefaultConnectionFactoryProvider(new ClientCodecPipelineFactory()));
    }

    public DefaultPinpointClientFactory(ChannelFactory channelFactory, Timer timer, ConnectionFactoryProvider connectionFactoryProvider) {
        this.channelFactory = (ChannelFactory)Assert.requireNonNull((Object)channelFactory, (String)"channelFactory must not be null");
        this.timer = (Timer)Assert.requireNonNull((Object)timer, (String)"timer must not be null");
        this.useExternalResource = true;
        this.socketOptionBuilder = new SocketOption.Builder();
        this.connectionFactoryProvider = (ConnectionFactoryProvider)Assert.requireNonNull((Object)connectionFactoryProvider, (String)"connectionFactoryProvider must not be null");
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.socketOptionBuilder.setConnectTimeout(connectTimeout);
    }

    @Override
    public int getConnectTimeout() {
        return this.socketOptionBuilder.getConnectTimeout();
    }

    @Override
    public void setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        this.socketOptionBuilder.setWriteBufferHighWaterMark(writeBufferHighWaterMark);
    }

    @Override
    public int getWriteBufferHighWaterMark() {
        return this.socketOptionBuilder.getWriteBufferHighWaterMark();
    }

    @Override
    public void setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        this.socketOptionBuilder.setWriteBufferLowWaterMark(writeBufferLowWaterMark);
    }

    @Override
    public int getWriteBufferLowWaterMark() {
        return this.socketOptionBuilder.getWriteBufferLowWaterMark();
    }

    @Override
    public long getReconnectDelay() {
        return this.clientOptionBuilder.getReconnectDelay();
    }

    @Override
    public void setReconnectDelay(long reconnectDelay) {
        this.clientOptionBuilder.setReconnectDelay(reconnectDelay);
    }

    @Override
    public long getPingDelay() {
        return this.clientOptionBuilder.getPingDelay();
    }

    @Override
    public void setPingDelay(long pingDelay) {
        this.clientOptionBuilder.setPingDelay(pingDelay);
    }

    @Override
    public long getEnableWorkerPacketDelay() {
        return this.clientOptionBuilder.getEnableWorkerPacketDelay();
    }

    @Override
    public void setEnableWorkerPacketDelay(long enableWorkerPacketDelay) {
        this.clientOptionBuilder.setEnableWorkerPacketDelay(enableWorkerPacketDelay);
    }

    @Override
    public long getWriteTimeoutMillis() {
        return this.clientOptionBuilder.getWriteTimeoutMillis();
    }

    @Override
    public void setWriteTimeoutMillis(long writeTimeoutMillis) {
        this.clientOptionBuilder.setWriteTimeoutMillis(writeTimeoutMillis);
    }

    @Override
    public long getRequestTimeoutMillis() {
        return this.clientOptionBuilder.getRequestTimeoutMillis();
    }

    @Override
    public void setRequestTimeoutMillis(long requestTimeoutMillis) {
        this.clientOptionBuilder.setRequestTimeoutMillis(requestTimeoutMillis);
    }

    @Override
    public PinpointClient connect(String host, int port) throws PinpointSocketException {
        DnsSocketAddressProvider socketAddressProvider = new DnsSocketAddressProvider(host, port);
        return this.connect(socketAddressProvider);
    }

    @Override
    @Deprecated
    public PinpointClient connect(InetSocketAddress connectAddress) throws PinpointSocketException {
        StaticSocketAddressProvider socketAddressProvider = new StaticSocketAddressProvider(connectAddress);
        return this.connect(socketAddressProvider);
    }

    @Override
    public PinpointClient connect(SocketAddressProvider socketAddressProvider) throws PinpointSocketException {
        Connection connection = this.connectInternal(socketAddressProvider, false);
        return connection.awaitConnected();
    }

    private Connection connectInternal(SocketAddressProvider socketAddressProvider, boolean reconnect) {
        ConnectionFactory connectionFactory = this.createConnectionFactory();
        return connectionFactory.connect(socketAddressProvider, reconnect);
    }

    private ConnectionFactory createConnectionFactory() {
        ClientOption clientOption = this.clientOptionBuilder.build();
        ClusterOption clusterOption = ClusterOption.copy(this.clusterOption);
        MessageListener messageListener = this.getMessageListener(SimpleMessageListener.INSTANCE);
        ServerStreamChannelMessageListener serverStreamChannelMessageListener = this.getServerStreamChannelMessageListener(DisabledServerStreamChannelMessageListener.INSTANCE);
        List<StateChangeEventListener> stateChangeEventListeners = this.getStateChangeEventListeners();
        HashMap<String, Object> copyProperties = new HashMap<String, Object>(this.properties);
        HandshakerFactory handshakerFactory = new HandshakerFactory(this.socketId, copyProperties, clientOption, clusterOption);
        DefaultPinpointClientHandlerFactory clientHandlerFactory = new DefaultPinpointClientHandlerFactory(clientOption, clusterOption, handshakerFactory, messageListener, serverStreamChannelMessageListener, stateChangeEventListeners);
        SocketOption socketOption = this.socketOptionBuilder.build();
        return this.connectionFactoryProvider.get(this.timer, this.closed, this.channelFactory, socketOption, clientOption, clientHandlerFactory);
    }

    @Override
    public PinpointClient scheduledConnect(String host, int port) {
        DnsSocketAddressProvider socketAddressProvider = new DnsSocketAddressProvider(host, port);
        return this.scheduledConnect(socketAddressProvider);
    }

    @Override
    @Deprecated
    public PinpointClient scheduledConnect(InetSocketAddress connectAddress) {
        StaticSocketAddressProvider socketAddressProvider = new StaticSocketAddressProvider(connectAddress);
        return this.scheduledConnect(socketAddressProvider);
    }

    @Override
    public PinpointClient scheduledConnect(SocketAddressProvider socketAddressProvider) {
        Assert.requireNonNull((Object)socketAddressProvider, (String)"socketAddressProvider must not be null");
        DefaultPinpointClient pinpointClient = new DefaultPinpointClient(new ReconnectStateClientHandler());
        ConnectionFactory connectionFactory = this.createConnectionFactory();
        connectionFactory.reconnect(pinpointClient, socketAddressProvider);
        return pinpointClient;
    }

    @Override
    @Deprecated
    public ChannelFuture reconnect(SocketAddress remoteAddress) {
        if (!(remoteAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("invalid remoteAddress:" + remoteAddress);
        }
        StaticSocketAddressProvider socketAddressProvider = new StaticSocketAddressProvider((InetSocketAddress)remoteAddress);
        Connection connection = this.connectInternal(socketAddressProvider, true);
        return connection.getConnectFuture();
    }

    @Override
    public void release() {
        if (this.closed.isClosed()) {
            return;
        }
        if (!this.closed.close()) {
            return;
        }
        if (!this.useExternalResource) {
            Set stop;
            ChannelFactory channelFactory = this.channelFactory;
            if (channelFactory != null) {
                channelFactory.releaseExternalResources();
            }
            if (!(stop = this.timer.stop()).isEmpty()) {
                this.logger.info("stop Timeout:{}", (Object)stop.size());
            }
        }
    }

    @Override
    public void setProperties(Map<String, Object> agentProperties) {
        Assert.requireNonNull(this.properties, (String)"agentProperties must not be null");
        this.properties = new HashMap<String, Object>(agentProperties);
    }

    @Override
    public ClusterOption getClusterOption() {
        return this.clusterOption;
    }

    @Override
    public void setClusterOption(String id, List<Role> roles) {
        this.clusterOption = new ClusterOption(true, id, roles);
    }

    @Override
    public void setClusterOption(ClusterOption clusterOption) {
        this.clusterOption = clusterOption;
    }

    @Override
    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    @Override
    public MessageListener getMessageListener(MessageListener defaultMessageListener) {
        if (this.messageListener == null) {
            return defaultMessageListener;
        }
        return this.messageListener;
    }

    @Override
    public void setMessageListener(MessageListener messageListener) {
        Assert.requireNonNull((Object)messageListener, (String)"messageListener must not be null");
        this.messageListener = messageListener;
    }

    @Override
    public ServerStreamChannelMessageListener getServerStreamChannelMessageListener() {
        return this.serverStreamChannelMessageListener;
    }

    @Override
    public ServerStreamChannelMessageListener getServerStreamChannelMessageListener(ServerStreamChannelMessageListener defaultStreamMessageListener) {
        if (this.serverStreamChannelMessageListener == null) {
            return defaultStreamMessageListener;
        }
        return this.serverStreamChannelMessageListener;
    }

    @Override
    public void setServerStreamChannelMessageListener(ServerStreamChannelMessageListener serverStreamChannelMessageListener) {
        Assert.requireNonNull((Object)serverStreamChannelMessageListener, (String)"serverStreamChannelMessageListener must not be null");
        this.serverStreamChannelMessageListener = serverStreamChannelMessageListener;
    }

    @Override
    public List<StateChangeEventListener> getStateChangeEventListeners() {
        return new ArrayList<StateChangeEventListener>(this.stateChangeEventListeners);
    }

    @Override
    public void addStateChangeEventListener(StateChangeEventListener stateChangeEventListener) {
        this.stateChangeEventListeners.add(stateChangeEventListener);
    }

    private int nextSocketId() {
        return this.socketId.getAndIncrement();
    }

    static {
        LoggerFactorySetup.setupSlf4jLoggerFactory();
    }
}

