/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.kafka.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.kafka.KafkaConstants;
import com.navercorp.pinpoint.plugin.kafka.field.accessor.RemoteAddressFieldAccessor;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;

public class ProducerSendInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    private final AtomicReference<HeaderSetter> headerSetterReference = new AtomicReference();

    public ProducerSendInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
    }

    public void before(Object target, Object[] args) {
        ProducerRecord record;
        if (this.logger.isDebugEnabled()) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((record = this.getProducerRecord(args)) == null) {
            return;
        }
        Trace trace = this.traceContext.currentTraceObject();
        if (trace == null) {
            return;
        }
        if (trace.canSampled()) {
            SpanEventRecorder recorder = trace.traceBlockBegin();
            recorder.recordServiceType(KafkaConstants.KAFKA_CLIENT);
            this.setPinpointHeaders(recorder, trace, record, true);
        } else {
            this.setPinpointHeaders(null, trace, record, false);
        }
    }

    private ProducerRecord getProducerRecord(Object[] args) {
        if (ArrayUtils.isEmpty((Object[])args)) {
            return null;
        }
        if (args[0] instanceof ProducerRecord) {
            return (ProducerRecord)args[0];
        }
        return null;
    }

    private void setPinpointHeaders(SpanEventRecorder recorder, Trace trace, ProducerRecord record, boolean sample) {
        HeaderSetter headerSetter = this.headerSetterReference.get();
        if (headerSetter == null) {
            headerSetter = HeaderSetterProvider.get(record);
            this.headerSetterReference.compareAndSet(null, headerSetter);
        }
        headerSetter.setPinpointHeaders(recorder, trace, record, sample, this.traceContext.getApplicationName(), this.traceContext.getServerTypeCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        ProducerRecord record;
        if (this.logger.isDebugEnabled()) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((record = this.getProducerRecord(args)) == null) {
            return;
        }
        Trace trace = this.traceContext.currentTraceObject();
        if (trace == null) {
            return;
        }
        if (!trace.canSampled()) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            if (throwable != null) {
                recorder.recordException(throwable);
            } else {
                String remoteAddress = this.getRemoteAddress(target);
                recorder.recordEndPoint(remoteAddress);
                String topic = record.topic();
                recorder.recordDestinationId(remoteAddress);
                recorder.recordAttribute(KafkaConstants.KAFKA_TOPIC_ANNOTATION_KEY, topic);
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private String getRemoteAddress(Object remoteAddressFieldAccessor) {
        String remoteAddress = null;
        if (remoteAddressFieldAccessor instanceof RemoteAddressFieldAccessor) {
            remoteAddress = ((RemoteAddressFieldAccessor)remoteAddressFieldAccessor)._$PINPOINT$_getRemoteAddress();
        }
        if (StringUtils.isEmpty(remoteAddress)) {
            return "Unknown";
        }
        return remoteAddress;
    }

    private static class DefaultHeaderSetter
    implements HeaderSetter {
        private DefaultHeaderSetter() {
        }

        @Override
        public void setPinpointHeaders(SpanEventRecorder recorder, Trace trace, ProducerRecord record, boolean sample, String applicationName, short serverTypeCode) {
            Headers kafkaHeaders = record.headers();
            if (kafkaHeaders == null) {
                return;
            }
            this.cleanPinpointHeader(kafkaHeaders);
            if (sample) {
                TraceId nextId = trace.getTraceId().getNextTraceId();
                recorder.recordNextSpanId(nextId.getSpanId());
                kafkaHeaders.add((Header)new RecordHeader(com.navercorp.pinpoint.bootstrap.context.Header.HTTP_TRACE_ID.toString(), nextId.getTransactionId().getBytes(KafkaConstants.DEFAULT_PINPOINT_HEADER_CHARSET)));
                kafkaHeaders.add((Header)new RecordHeader(com.navercorp.pinpoint.bootstrap.context.Header.HTTP_SPAN_ID.toString(), String.valueOf(nextId.getSpanId()).getBytes(KafkaConstants.DEFAULT_PINPOINT_HEADER_CHARSET)));
                kafkaHeaders.add((Header)new RecordHeader(com.navercorp.pinpoint.bootstrap.context.Header.HTTP_PARENT_SPAN_ID.toString(), String.valueOf(nextId.getParentSpanId()).getBytes(KafkaConstants.DEFAULT_PINPOINT_HEADER_CHARSET)));
                kafkaHeaders.add((Header)new RecordHeader(com.navercorp.pinpoint.bootstrap.context.Header.HTTP_FLAGS.toString(), String.valueOf(nextId.getFlags()).getBytes(KafkaConstants.DEFAULT_PINPOINT_HEADER_CHARSET)));
                kafkaHeaders.add((Header)new RecordHeader(com.navercorp.pinpoint.bootstrap.context.Header.HTTP_PARENT_APPLICATION_NAME.toString(), String.valueOf(applicationName).getBytes(KafkaConstants.DEFAULT_PINPOINT_HEADER_CHARSET)));
                kafkaHeaders.add((Header)new RecordHeader(com.navercorp.pinpoint.bootstrap.context.Header.HTTP_PARENT_APPLICATION_TYPE.toString(), Short.toString(serverTypeCode).getBytes(KafkaConstants.DEFAULT_PINPOINT_HEADER_CHARSET)));
            } else {
                kafkaHeaders.add((Header)new RecordHeader(com.navercorp.pinpoint.bootstrap.context.Header.HTTP_SAMPLED.toString(), "s0".getBytes(KafkaConstants.DEFAULT_PINPOINT_HEADER_CHARSET)));
            }
        }

        private void cleanPinpointHeader(Headers kafkaHeaders) {
            Assert.requireNonNull((Object)kafkaHeaders, (String)"kafkaHeaders must not be null");
            for (Header kafkaHeader : kafkaHeaders.toArray()) {
                String kafkaHeaderKey = kafkaHeader.key();
                if (!com.navercorp.pinpoint.bootstrap.context.Header.startWithPinpointHeader((String)kafkaHeaderKey)) continue;
                kafkaHeaders.remove(kafkaHeaderKey);
            }
        }
    }

    private static class DisabledHeaderSetter
    implements HeaderSetter {
        private DisabledHeaderSetter() {
        }

        @Override
        public void setPinpointHeaders(SpanEventRecorder recorder, Trace trace, ProducerRecord record, boolean sample, String applicationName, short serverTypeCode) {
        }
    }

    private static interface HeaderSetter {
        public void setPinpointHeaders(SpanEventRecorder var1, Trace var2, ProducerRecord var3, boolean var4, String var5, short var6);
    }

    private static class HeaderSetterProvider {
        private HeaderSetterProvider() {
        }

        static HeaderSetter get(Object object) {
            try {
                Class<?> aClass = object.getClass();
                Method method = aClass.getMethod("headers", new Class[0]);
                if (method != null) {
                    return new DefaultHeaderSetter();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return new DisabledHeaderSetter();
        }
    }
}

