/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.io.util;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.apache.IntHashMap;
import com.navercorp.pinpoint.io.header.Header;
import com.navercorp.pinpoint.io.util.BodyFactory;
import com.navercorp.pinpoint.io.util.TypeLocator;
import java.util.List;
import java.util.Map;

public class DefaultTypeLocator<T>
implements TypeLocator<T> {
    private final IntHashMap<BodyFactory<T>> bodyFactoryMap;
    private final Map<Class<?>, Header> bodyToHeaderMap;
    private final Entry<Class<?>, Header>[] bodyClassToHeaderArray;
    private final IntHashMap<Header> headerMap;

    DefaultTypeLocator(IntHashMap<BodyFactory<T>> bodyFactoryMap, Map<Class<?>, Header> bodyToHeaderMap, IntHashMap<Header> headerMap, List<Entry<Class<?>, Header>> bodyClassToHeaderList) {
        this.bodyFactoryMap = (IntHashMap)Assert.requireNonNull(bodyFactoryMap, (String)"bodyFactoryMap must not be null");
        this.bodyToHeaderMap = (Map)Assert.requireNonNull(bodyToHeaderMap, (String)"bodyToHeaderMap must not be null");
        this.headerMap = (IntHashMap)Assert.requireNonNull(headerMap, (String)"headerMap  must not be null");
        Assert.requireNonNull(bodyClassToHeaderList, (String)"bodyClassToHeaderList must not be null");
        this.bodyClassToHeaderArray = bodyClassToHeaderList.toArray(new Entry[0]);
    }

    @Override
    public T bodyLookup(short type) {
        BodyFactory bodyFactory = (BodyFactory)this.bodyFactoryMap.get((int)type);
        if (bodyFactory != null) {
            return bodyFactory.getObject();
        }
        return null;
    }

    @Override
    public Header headerLookup(T body) {
        if (body == null) {
            throw new IllegalArgumentException("body must not be null");
        }
        for (Entry<Class<?>, Header> entry : this.bodyClassToHeaderArray) {
            Class bodyClass = (Class)((Entry)entry).key;
            if (!bodyClass.isInstance(body)) continue;
            return (Header)((Entry)entry).value;
        }
        return null;
    }

    @Override
    public Header headerLookup(short type) {
        return (Header)this.headerMap.get((int)type);
    }

    @Override
    public boolean isSupport(short type) {
        BodyFactory bodyFactory = (BodyFactory)this.bodyFactoryMap.get((int)type);
        return bodyFactory != null;
    }

    @Override
    public boolean isSupport(Class<? extends T> clazz) {
        Header header = this.bodyToHeaderMap.get(clazz);
        return header != null;
    }

    static class Entry<K, V> {
        private final K key;
        private final V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

