/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.hystrix.interceptor.metrics;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.plugin.hystrix.HystrixPluginConstants;
import com.navercorp.pinpoint.plugin.hystrix.descriptor.HystrixCircuitBreakerMethodDescriptor;
import com.navercorp.pinpoint.plugin.hystrix.field.HystrixKeyNameAccessor;

public class HystrixCircuitBreakerConstructInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    private static final HystrixCircuitBreakerMethodDescriptor HYSTRIX_CIRCUIT_BREAKER_METHOD_DESCRIPTOR = new HystrixCircuitBreakerMethodDescriptor();

    public HystrixCircuitBreakerConstructInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        super(traceContext, descriptor);
        traceContext.cacheApi((MethodDescriptor)HYSTRIX_CIRCUIT_BREAKER_METHOD_DESCRIPTOR);
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        recorder.recordServiceType(HystrixPluginConstants.HYSTRIX_INTERNAL_SERVICE_TYPE);
        recorder.recordApi((MethodDescriptor)HYSTRIX_CIRCUIT_BREAKER_METHOD_DESCRIPTOR);
        recorder.recordException(throwable);
        if (args != null && args.length > 1) {
            String commandGroupKey;
            String commandKey;
            if (args[0] instanceof HystrixKeyNameAccessor && (commandKey = ((HystrixKeyNameAccessor)args[0])._$PINPOINT$_getHystrixKeyName()) != null) {
                recorder.recordAttribute(HystrixPluginConstants.HYSTRIX_COMMAND_KEY_ANNOTATION_KEY, commandKey);
            }
            if (args[1] instanceof HystrixKeyNameAccessor && (commandGroupKey = ((HystrixKeyNameAccessor)args[1])._$PINPOINT$_getHystrixKeyName()) != null) {
                recorder.recordAttribute(HystrixPluginConstants.HYSTRIX_COMMAND_GROUP_KEY_ANNOTATION_KEY, commandGroupKey);
            }
        }
    }
}

