/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class ByteArrayOutputStreamTransport
extends TTransport {
    private final ByteArrayOutputStream out;

    public ByteArrayOutputStreamTransport(ByteArrayOutputStream out) {
        this.out = out;
    }

    public ByteArrayOutputStream getByteArrayOutputStream() {
        return this.out;
    }

    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isOpen() {
        return true;
    }

    public void open() throws TTransportException {
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        throw new TTransportException(1, "unsupported inputStream");
    }

    public void write(byte[] buf, int off, int len) throws TTransportException {
        if (this.out == null) {
            throw new TTransportException(1, "cannot write to null outputStream");
        }
        this.out.write(buf, off, len);
    }

    public void flush() throws TTransportException {
        this.out.reset();
    }

    public byte[] getBuffer() {
        return this.out.toByteArray();
    }

    public int getBufferPosition() {
        return this.out.size();
    }

    public int getBytesRemainingInBuffer() {
        return -1;
    }

    public void consumeBuffer(int len) {
        throw new UnsupportedOperationException("unsupported ByteArrayOutputStream operation");
    }
}

