/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.fastjson;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.plugin.fastjson.FastjsonConfig;
import java.security.ProtectionDomain;

public class FastjsonPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }

    public void setup(ProfilerPluginSetupContext context) {
        FastjsonConfig config = new FastjsonConfig(context.getConfig());
        this.logger.debug("[Fastjson] Initialized config={}", (Object)config);
        if (config.isProfile()) {
            this.transformTemplate.transform("com.alibaba.fastjson.JSON", new TransformCallback(){

                public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                    InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                    for (InstrumentMethod m : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"parse"}))) {
                        m.addScopedInterceptor("com.navercorp.pinpoint.plugin.fastjson.interceptor.ParseInterceptor", "FASTJSON_SCOPE");
                    }
                    for (InstrumentMethod m : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"parseObject"}))) {
                        m.addScopedInterceptor("com.navercorp.pinpoint.plugin.fastjson.interceptor.ParseObjectInterceptor", "FASTJSON_SCOPE");
                    }
                    for (InstrumentMethod m : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"parseArray"}))) {
                        m.addScopedInterceptor("com.navercorp.pinpoint.plugin.fastjson.interceptor.ParseArrayInterceptor", "FASTJSON_SCOPE");
                    }
                    for (InstrumentMethod m : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"toJSON"}))) {
                        m.addScopedInterceptor("com.navercorp.pinpoint.plugin.fastjson.interceptor.ToJsonInterceptor", "FASTJSON_SCOPE");
                    }
                    for (InstrumentMethod m : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"toJavaObject"}))) {
                        m.addScopedInterceptor("com.navercorp.pinpoint.plugin.fastjson.interceptor.ToJavaObjectInterceptor", "FASTJSON_SCOPE");
                    }
                    for (InstrumentMethod m : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"toJSONString"}))) {
                        m.addScopedInterceptor("com.navercorp.pinpoint.plugin.fastjson.interceptor.ToJsonStringInterceptor", "FASTJSON_SCOPE");
                    }
                    for (InstrumentMethod m : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"toJSONBytes"}))) {
                        m.addScopedInterceptor("com.navercorp.pinpoint.plugin.fastjson.interceptor.ToJsonBytesInterceptor", "FASTJSON_SCOPE");
                    }
                    for (InstrumentMethod m : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"writeJSONString"}))) {
                        m.addScopedInterceptor("com.navercorp.pinpoint.plugin.fastjson.interceptor.WriteJsonStringInterceptor", "FASTJSON_SCOPE");
                    }
                    return target.toBytecode();
                }
            });
        }
    }
}

