/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.instrument.ASMEngine;
import com.navercorp.pinpoint.profiler.instrument.DefaultEngineComponent;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.ScopeFactory;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorDefinitionFactory;
import com.navercorp.pinpoint.profiler.interceptor.registry.InterceptorRegistryBinder;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import com.navercorp.pinpoint.profiler.objectfactory.ObjectBinderFactory;
import java.lang.instrument.Instrumentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentEngineProvider
implements Provider<InstrumentEngine> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ProfilerConfig profilerConfig;
    private final InterceptorRegistryBinder interceptorRegistryBinder;
    private final Provider<ApiMetaDataService> apiMetaDataServiceProvider;
    private final ObjectBinderFactory objectBinderFactory;
    private final Instrumentation instrumentation;

    @Inject
    public InstrumentEngineProvider(ProfilerConfig profilerConfig, Instrumentation instrumentation, ObjectBinderFactory objectBinderFactory, InterceptorRegistryBinder interceptorRegistryBinder, Provider<ApiMetaDataService> apiMetaDataServiceProvider) {
        this.profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig must not be null");
        this.instrumentation = (Instrumentation)Assert.requireNonNull((Object)instrumentation, (String)"instrumentation must not be null");
        this.objectBinderFactory = (ObjectBinderFactory)Assert.requireNonNull((Object)objectBinderFactory, (String)"objectBinderFactory must not be null");
        this.interceptorRegistryBinder = (InterceptorRegistryBinder)Assert.requireNonNull((Object)interceptorRegistryBinder, (String)"interceptorRegistryBinder must not be null");
        this.apiMetaDataServiceProvider = (Provider)Assert.requireNonNull(apiMetaDataServiceProvider, (String)"apiMetaDataServiceProvider must not be null");
    }

    public InstrumentEngine get() {
        String instrumentEngine = this.profilerConfig.getProfileInstrumentEngine().toUpperCase();
        if ("ASM".equals(instrumentEngine)) {
            this.logger.info("ASM InstrumentEngine");
            InterceptorDefinitionFactory interceptorDefinitionFactory = new InterceptorDefinitionFactory();
            ScopeFactory scopeFactory = new ScopeFactory();
            DefaultEngineComponent engineComponent = new DefaultEngineComponent(this.objectBinderFactory, this.interceptorRegistryBinder, interceptorDefinitionFactory, this.apiMetaDataServiceProvider, scopeFactory);
            return new ASMEngine(this.instrumentation, engineComponent);
        }
        this.logger.warn("Unknown InstrumentEngine:{}", (Object)instrumentEngine);
        throw new IllegalArgumentException("Unknown InstrumentEngine:" + instrumentEngine);
    }
}

