/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.resttemplate.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.resttemplate.ExecAsyncResultMethodDescriptor;
import com.navercorp.pinpoint.plugin.resttemplate.RestTemplateConstants;
import com.navercorp.pinpoint.plugin.resttemplate.field.accessor.TraceFutureFlagAccessor;
import org.springframework.util.concurrent.ListenableFuture;

public class AsyncHttpRequestInterceptor
implements AroundInterceptor {
    private static final ExecAsyncResultMethodDescriptor execAsyncResultMethodDescriptor = new ExecAsyncResultMethodDescriptor();
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;

    public AsyncHttpRequestInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        traceContext.cacheApi((MethodDescriptor)execAsyncResultMethodDescriptor);
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        recorder.recordServiceType(RestTemplateConstants.SERVICE_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
            this.traceAndRecordFuture(result, throwable);
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceAndRecordFuture(Object result, Throwable throwable) {
        if (throwable != null) {
            return;
        }
        if (!(result instanceof ListenableFuture)) {
            return;
        }
        Trace virtualMethodTrace = this.traceContext.currentTraceObject();
        try {
            SpanEventRecorder recorder = virtualMethodTrace.traceBlockBegin();
            recorder.recordServiceType(RestTemplateConstants.SERVICE_TYPE);
            recorder.recordApi((MethodDescriptor)execAsyncResultMethodDescriptor);
            if (this.isAsynchronousInvocation(result)) {
                AsyncContext asyncContext = recorder.recordNextAsyncContext();
                ((AsyncContextAccessor)result)._$PINPOINT$_setAsyncContext(asyncContext);
                if (this.isDebug) {
                    this.logger.debug("Set AsyncContext {}", (Object)asyncContext);
                }
                if (result instanceof TraceFutureFlagAccessor) {
                    ((TraceFutureFlagAccessor)result)._$PINPOINT$_setTraceFlag(true);
                }
            }
        }
        finally {
            virtualMethodTrace.traceBlockEnd();
        }
    }

    private boolean isAsynchronousInvocation(Object result) {
        if (!(result instanceof AsyncContextAccessor)) {
            this.logger.debug("Invalid result object. Need accessor({}).", (Object)AsyncContextAccessor.class.getName());
            return false;
        }
        return true;
    }
}

