/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.agentdir;

import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.bootstrap.agentdir.JarFileUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;

public class BootDir {
    private final BootLogger logger = BootLogger.getLogger(this.getClass().getName());
    private final String commons;
    private final String bootstrapCore;
    private final String bootstrapCoreOptional;
    private final String bootstrapJava8;
    private final String bootstrapJava9;
    private final String annotations;

    public BootDir(String commons, String bootstrapCore, String bootstrapCoreOptional, String bootstrapJava8, String bootstrapJava9, String annotations) {
        if (commons == null) {
            throw new NullPointerException("commons must not be null");
        }
        if (bootstrapCore == null) {
            throw new NullPointerException("bootstrapCore must not be null");
        }
        this.commons = commons;
        this.bootstrapCore = bootstrapCore;
        this.bootstrapCoreOptional = bootstrapCoreOptional;
        this.bootstrapJava8 = bootstrapJava8;
        this.bootstrapJava9 = bootstrapJava9;
        this.annotations = annotations;
        this.verify();
    }

    private void verify() {
        String annotationsJar;
        String bootStrapJava9Jar;
        String bootStrapJava8Jar;
        String pinpointCommonsJar = this.getCommons();
        if (pinpointCommonsJar == null) {
            throw new IllegalStateException("pinpoint-commons-x.x.x(-SNAPSHOT).jar not found");
        }
        String bootStrapCoreJar = this.getBootstrapCore();
        if (bootStrapCoreJar == null) {
            throw new IllegalStateException("pinpoint-bootstrap-core-x.x.x(-SNAPSHOT).jar not found");
        }
        String bootStrapCoreOptionalJar = this.getBootstrapCoreOptional();
        if (bootStrapCoreOptionalJar == null) {
            this.logger.info("pinpoint-bootstrap-core-optional-x.x.x(-SNAPSHOT).jar not found");
        }
        if ((bootStrapJava8Jar = this.getBootstrapJava8()) == null) {
            this.logger.info("pinpoint-bootstrap-java8-x.x.x(-SNAPSHOT).jar not found");
        }
        if ((bootStrapJava9Jar = this.getBootstrapJava9()) == null) {
            this.logger.info("pinpoint-bootstrap-java9-x.x.x(-SNAPSHOT).jar not found");
        }
        if ((annotationsJar = this.getAnnotations()) == null) {
            this.logger.info("pinpoint-annotations-x.x.x(-SNAPSHOT).jar not found");
        }
    }

    public String getCommons() {
        return this.commons;
    }

    public String getBootstrapCore() {
        return this.bootstrapCore;
    }

    public String getBootstrapCoreOptional() {
        return this.bootstrapCoreOptional;
    }

    public String getBootstrapJava8() {
        return this.bootstrapJava8;
    }

    public String getBootstrapJava9() {
        return this.bootstrapJava9;
    }

    public String getAnnotations() {
        return this.annotations;
    }

    public List<String> toList() {
        ArrayList<String> list = new ArrayList<String>();
        this.addFilePath(list, this.commons, true);
        this.addFilePath(list, this.bootstrapCore, true);
        this.addFilePath(list, this.bootstrapCoreOptional, false);
        this.addFilePath(list, this.bootstrapJava8, false);
        this.addFilePath(list, this.bootstrapJava9, false);
        this.addFilePath(list, this.annotations, false);
        return list;
    }

    private void addFilePath(List<String> list, String filePath, boolean required) {
        if (required) {
            if (filePath == null) {
                throw new IllegalStateException("filePath must not be null");
            }
        } else if (filePath == null) {
            return;
        }
        list.add(filePath);
    }

    public List<JarFile> openJarFiles() {
        ArrayList<JarFile> jarFileList = new ArrayList<JarFile>();
        this.addJarFile(jarFileList, this.commons, true);
        this.addJarFile(jarFileList, this.bootstrapCore, true);
        this.addJarFile(jarFileList, this.bootstrapCoreOptional, false);
        this.addJarFile(jarFileList, this.bootstrapJava8, false);
        this.addJarFile(jarFileList, this.bootstrapJava9, false);
        this.addJarFile(jarFileList, this.annotations, false);
        return jarFileList;
    }

    private void addJarFile(List<JarFile> list, String filePath, boolean required) {
        if (required) {
            if (filePath == null) {
                throw new IllegalStateException("filePath must not be null");
            }
        } else if (filePath == null) {
            return;
        }
        JarFile jarFile = JarFileUtils.openJarFile(filePath);
        list.add(jarFile);
    }
}

