/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.metadata;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.navercorp.pinpoint.common.util.BytesUtils;
import com.navercorp.pinpoint.profiler.metadata.Result;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleCache<T> {
    private final AtomicInteger idGen;
    private final ConcurrentMap<T, Result> cache;

    public SimpleCache() {
        this(1024, 1);
    }

    public SimpleCache(int cacheSize) {
        this(cacheSize, 1);
    }

    public SimpleCache(int cacheSize, int startValue) {
        this.idGen = new AtomicInteger(startValue);
        this.cache = this.createCache(cacheSize);
    }

    private ConcurrentMap<T, Result> createCache(int maxCacheSize) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        cacheBuilder.concurrencyLevel(64);
        cacheBuilder.initialCapacity(maxCacheSize);
        cacheBuilder.maximumSize((long)maxCacheSize);
        Cache localCache = cacheBuilder.build();
        ConcurrentMap cache = localCache.asMap();
        return cache;
    }

    public Result put(T value) {
        Result find = (Result)this.cache.get(value);
        if (find != null) {
            return find;
        }
        int newId = BytesUtils.zigzagToInt((int)this.idGen.getAndIncrement());
        Result result = new Result(false, newId);
        Result before = this.cache.putIfAbsent(value, result);
        if (before != null) {
            return before;
        }
        return new Result(true, newId);
    }
}

