/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.agent;

import com.secnium.iast.agent.AttachLauncher;
import com.secnium.iast.thirdparty.org.apache.commons.cli.CommandLine;
import com.secnium.iast.thirdparty.org.apache.commons.cli.DefaultParser;
import com.secnium.iast.thirdparty.org.apache.commons.cli.HelpFormatter;
import com.secnium.iast.thirdparty.org.apache.commons.cli.Option;
import com.secnium.iast.thirdparty.org.apache.commons.cli.Options;
import com.secnium.iast.thirdparty.org.apache.commons.cli.ParseException;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class Agent {
    public static void main(String[] args) {
        Options attachOptions = new Options();
        attachOptions.addOption(Agent.build("p", "pid", "webserver process id"));
        attachOptions.addOption(Agent.build("m", "mode", "optional: install uninstall"));
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine result = null;
        try {
            result = parser.parse(attachOptions, args);
            if (result.hasOption("p") && result.hasOption("m")) {
                String pid = result.getOptionValue("p");
                String mode = result.getOptionValue("m");
                String attachArgs = null;
                attachArgs = mode;
                if (Agent.appendToolsPath()) {
                    AttachLauncher.attach(pid, attachArgs);
                    System.out.println("engine " + attachArgs + " success for pid: " + pid);
                } else {
                    System.out.println("engine " + attachArgs + " failed for pid: " + pid);
                }
            } else {
                formatter.printHelp("java -jar agent.jar", attachOptions, true);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static Option build(String opt, String longOpt, String desc) {
        return Option.builder(opt).longOpt(longOpt).hasArg().desc(desc).build();
    }

    public static boolean appendToolsPath() {
        try {
            File file = new File(new File(System.getProperty("java.home")).getParent(), "lib/tools.jar");
            if (!file.exists()) {
                System.out.println("Not running with JDK!");
                throw new RuntimeException("Not running with JDK!");
            }
            URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlClassLoader, file.toURI().toURL());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

