/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.thrift.interceptor.client;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.thrift.ThriftConstants;
import org.apache.thrift.TBase;

public class TServiceClientReceiveBaseInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    private final boolean traceServiceResult;

    public TServiceClientReceiveBaseInterceptor(TraceContext context, MethodDescriptor descriptor, boolean traceServiceResult) {
        super(context, descriptor);
        this.traceServiceResult = traceServiceResult;
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
        recorder.recordServiceType(ThriftConstants.THRIFT_CLIENT_INTERNAL);
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        recorder.recordApi(this.getMethodDescriptor());
        if (throwable == null && this.traceServiceResult) {
            if (args.length == 2 && args[0] instanceof TBase) {
                String resultString = this.getResult((TBase)args[0]);
                recorder.recordAttribute(ThriftConstants.THRIFT_RESULT, resultString);
            }
        } else {
            recorder.recordException(throwable);
        }
    }

    private String getResult(TBase<?, ?> args) {
        return StringUtils.abbreviate((String)args.toString(), (int)256);
    }
}

