/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.netty;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.netty.NettyConfig;
import com.navercorp.pinpoint.plugin.netty.NettyConstants;
import com.navercorp.pinpoint.plugin.netty.transformer.http.HttpEncoderTransformer;
import com.navercorp.pinpoint.plugin.netty.transformer.http.HttpRequestTransformer;
import java.security.ProtectionDomain;

public class NettyPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private static final PLogger LOGGER = PLoggerFactory.getLogger(NettyPlugin.class);
    private static final boolean IS_DEBUG = LOGGER.isDebugEnabled();
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        NettyConfig config = new NettyConfig(context.getConfig());
        if (!config.isPluginEnable()) {
            LOGGER.info("Disable netty option. 'profiler.netty=false'");
            return;
        }
        this.transformTemplate.transform("io.netty.bootstrap.Bootstrap", (TransformCallback)new BootstrapTransformer());
        this.transformTemplate.transform("io.netty.channel.DefaultChannelPipeline", (TransformCallback)new ChannelPipelineTransformer());
        this.transformTemplate.transform("io.netty.util.concurrent.DefaultPromise", (TransformCallback)new PromiseTransformer());
        this.transformTemplate.transform("io.netty.channel.DefaultChannelPromise", (TransformCallback)new ChannelPromiseTransformer());
        if (config.isHttpCodecEnable()) {
            this.transformTemplate.transform("io.netty.handler.codec.http.DefaultHttpRequest", (TransformCallback)new HttpRequestTransformer());
            this.transformTemplate.transform("io.netty.handler.codec.http.HttpObjectEncoder", (TransformCallback)new HttpEncoderTransformer());
        }
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }

    private static class ChannelPromiseTransformer
    implements TransformCallback {
        private ChannelPromiseTransformer() {
        }

        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            InstrumentMethod addListenerMethod1 = target.getDeclaredMethod("addListener", new String[]{"io.netty.util.concurrent.GenericFutureListener"});
            if (addListenerMethod1 != null) {
                addListenerMethod1.addScopedInterceptor("com.navercorp.pinpoint.plugin.netty.interceptor.ChannelPromiseAddListenerInterceptor", "NETTY_SCOPE", ExecutionPolicy.BOUNDARY);
            } else if (IS_DEBUG) {
                LOGGER.debug("can't find addListener method");
            }
            InstrumentMethod addListenerMethod2 = target.getDeclaredMethod("addListeners", new String[]{"io.netty.util.concurrent.GenericFutureListener[]"});
            if (addListenerMethod2 != null) {
                addListenerMethod2.addScopedInterceptor("com.navercorp.pinpoint.plugin.netty.interceptor.ChannelPromiseAddListenerInterceptor", "NETTY_SCOPE", ExecutionPolicy.BOUNDARY);
            } else if (IS_DEBUG) {
                LOGGER.debug("can't find addListeners method");
            }
            return target.toBytecode();
        }
    }

    private static class PromiseTransformer
    implements TransformCallback {
        private PromiseTransformer() {
        }

        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            target.addField(AsyncContextAccessor.class.getName());
            InstrumentMethod notifyListenersNowMethod = target.getDeclaredMethod("notifyListenersNow", new String[0]);
            if (notifyListenersNowMethod != null) {
                notifyListenersNowMethod.addInterceptor("com.navercorp.pinpoint.plugin.netty.interceptor.ChannelPromiseNotifyInterceptor");
            } else if (IS_DEBUG) {
                LOGGER.debug("can't find notifyListenersNow method");
            }
            InstrumentMethod notifyListener0Method = target.getDeclaredMethod("notifyListener0", new String[]{"io.netty.util.concurrent.Future", "io.netty.util.concurrent.GenericFutureListener"});
            if (notifyListener0Method != null) {
                notifyListener0Method.addInterceptor("com.navercorp.pinpoint.bootstrap.interceptor.BasicMethodInterceptor", VarArgs.va((Object[])new Object[]{NettyConstants.SERVICE_TYPE_INTERNAL}));
            } else if (IS_DEBUG) {
                LOGGER.debug("can't find notifyListener0 method");
            }
            return target.toBytecode();
        }
    }

    private static class ChannelPipelineTransformer
    implements TransformCallback {
        private ChannelPipelineTransformer() {
        }

        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
            InstrumentMethod writeMethod1 = target.getDeclaredMethod("write", new String[]{"java.lang.Object"});
            if (writeMethod1 != null) {
                writeMethod1.addScopedInterceptor("com.navercorp.pinpoint.plugin.netty.interceptor.ChannelPipelineWriteInterceptor", "NETTY_WRITE_SCOPE", ExecutionPolicy.BOUNDARY);
            } else if (IS_DEBUG) {
                LOGGER.debug("can't find write(\"java.lang.Object\") method");
            }
            InstrumentMethod writeMethod2 = target.getDeclaredMethod("write", new String[]{"java.lang.Object", "io.netty.channel.ChannelPromise"});
            if (writeMethod2 != null) {
                writeMethod2.addScopedInterceptor("com.navercorp.pinpoint.plugin.netty.interceptor.ChannelPipelineWriteInterceptor", "NETTY_WRITE_SCOPE", ExecutionPolicy.BOUNDARY);
            } else if (IS_DEBUG) {
                LOGGER.debug("can't find write(\"java.lang.Object\", \"io.netty.channel.ChannelPromise\") method");
            }
            InstrumentMethod writeAndFlushMethod1 = target.getDeclaredMethod("writeAndFlush", new String[]{"java.lang.Object"});
            if (writeAndFlushMethod1 != null) {
                writeAndFlushMethod1.addScopedInterceptor("com.navercorp.pinpoint.plugin.netty.interceptor.ChannelPipelineWriteInterceptor", "NETTY_WRITE_SCOPE", ExecutionPolicy.BOUNDARY);
            } else if (IS_DEBUG) {
                LOGGER.debug("can't find writeAndFlush(\"java.lang.Object\") method");
            }
            InstrumentMethod writeAndFlushMethod2 = target.getDeclaredMethod("writeAndFlush", new String[]{"java.lang.Object", "io.netty.channel.ChannelPromise"});
            if (writeAndFlushMethod2 != null) {
                writeAndFlushMethod2.addScopedInterceptor("com.navercorp.pinpoint.plugin.netty.interceptor.ChannelPipelineWriteInterceptor", "NETTY_WRITE_SCOPE", ExecutionPolicy.BOUNDARY);
            } else if (IS_DEBUG) {
                LOGGER.debug("can't find writeAndFlush(\"java.lang.Object\", \"io.netty.channel.ChannelPromise\") method");
            }
            return target.toBytecode();
        }
    }

    private static class BootstrapTransformer
    implements TransformCallback {
        private BootstrapTransformer() {
        }

        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            InstrumentMethod connectMethod = target.getDeclaredMethod("connect", new String[0]);
            if (connectMethod != null) {
                connectMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.netty.interceptor.BootstrapConnectInterceptor", "NETTY_SCOPE", ExecutionPolicy.BOUNDARY);
            } else if (IS_DEBUG) {
                LOGGER.debug("can't find connect method");
            }
            InstrumentMethod connectMethod2 = target.getDeclaredMethod("connect", new String[]{"java.net.SocketAddress"});
            if (connectMethod2 != null) {
                connectMethod2.addScopedInterceptor("com.navercorp.pinpoint.plugin.netty.interceptor.BootstrapConnectInterceptor", "NETTY_SCOPE", ExecutionPolicy.BOUNDARY);
            } else if (IS_DEBUG) {
                LOGGER.debug("can't find connect(\"java.net.SocketAddress\") method");
            }
            InstrumentMethod connectMethod3 = target.getDeclaredMethod("connect", new String[]{"java.net.SocketAddress", "java.net.SocketAddress"});
            if (connectMethod3 != null) {
                connectMethod3.addScopedInterceptor("com.navercorp.pinpoint.plugin.netty.interceptor.BootstrapConnectInterceptor", "NETTY_SCOPE", ExecutionPolicy.BOUNDARY);
            } else if (IS_DEBUG) {
                LOGGER.debug("can't find connect(\"java.net.SocketAddress\", \"java.net.SocketAddress\") method");
            }
            return target.toBytecode();
        }
    }
}

