/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient3.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.httpclient3.HttpClient3CallContext;

public class HttpMethodBaseRequestAndResponseMethodInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor methodDescriptor;
    private final InterceptorScope interceptorScope;

    public HttpMethodBaseRequestAndResponseMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, InterceptorScope interceptorScope) {
        if (traceContext == null) {
            throw new NullPointerException("traceContext must not be null");
        }
        if (methodDescriptor == null) {
            throw new NullPointerException("methodDescriptor must not be null");
        }
        if (interceptorScope == null) {
            throw new NullPointerException("interceptorScope must not be null");
        }
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
        this.interceptorScope = interceptorScope;
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, this.methodDescriptor.getClassName(), this.methodDescriptor.getMethodName(), "", args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        InterceptorScopeInvocation invocation = this.interceptorScope.getCurrentInvocation();
        Object attachment = this.getAttachment(invocation);
        if (attachment instanceof HttpClient3CallContext) {
            HttpClient3CallContext callContext = (HttpClient3CallContext)attachment;
            if (this.methodDescriptor.getMethodName().equals("writeRequest")) {
                callContext.setWriteBeginTime(System.currentTimeMillis());
            } else {
                callContext.setReadBeginTime(System.currentTimeMillis());
            }
            this.logger.debug("Set call context {}", (Object)callContext);
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, this.methodDescriptor.getClassName(), this.methodDescriptor.getMethodName(), "", args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        InterceptorScopeInvocation invocation = this.interceptorScope.getCurrentInvocation();
        Object attachment = this.getAttachment(invocation);
        if (attachment instanceof HttpClient3CallContext) {
            HttpClient3CallContext callContext = (HttpClient3CallContext)attachment;
            if (this.methodDescriptor.getMethodName().equals("writeRequest")) {
                callContext.setWriteEndTime(System.currentTimeMillis());
                callContext.setWriteFail(throwable != null);
            } else {
                callContext.setReadEndTime(System.currentTimeMillis());
                callContext.setReadFail(throwable != null);
            }
            this.logger.debug("Set call context {}", (Object)callContext);
        }
    }

    private Object getAttachment(InterceptorScopeInvocation invocation) {
        if (invocation == null) {
            return null;
        }
        return invocation.getAttachment();
    }
}

