/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jetty.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServletRequestListenerInterceptorHelper;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.RemoteAddressResolverFactory;
import com.navercorp.pinpoint.plugin.jetty.JettyConfiguration;
import com.navercorp.pinpoint.plugin.jetty.JettyConstants;
import com.navercorp.pinpoint.plugin.jetty.common.servlet.util.HttpServletRequestAdaptor;
import com.navercorp.pinpoint.plugin.jetty.common.servlet.util.ParameterRecorderFactory;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractServerHandleInterceptor
implements AroundInterceptor {
    protected final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final boolean isInfo = this.logger.isInfoEnabled();
    private final MethodDescriptor methodDescriptor;
    private final ServletRequestListenerInterceptorHelper<HttpServletRequest> servletRequestListenerInterceptorHelper;

    public AbstractServerHandleInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.methodDescriptor = descriptor;
        JettyConfiguration config = new JettyConfiguration(traceContext.getProfilerConfig());
        HttpServletRequestAdaptor requestRequestAdaptor = new HttpServletRequestAdaptor();
        requestRequestAdaptor = RemoteAddressResolverFactory.wrapRealIpSupport((RequestAdaptor)requestRequestAdaptor, (String)config.getRealIpHeader(), (String)config.getRealIpEmptyValue());
        ParameterRecorder<HttpServletRequest> parameterRecorder = ParameterRecorderFactory.newParameterRecorderFactory(config.getExcludeProfileMethodFilter(), config.isTraceRequestParam());
        this.servletRequestListenerInterceptorHelper = new ServletRequestListenerInterceptorHelper(JettyConstants.JETTY, traceContext, (RequestAdaptor)requestRequestAdaptor, config.getExcludeUrlFilter(), parameterRecorder);
    }

    abstract HttpServletRequest toHttpServletRequest(Object[] var1);

    abstract HttpServletResponse toHttpServletResponse(Object[] var1);

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        try {
            HttpServletRequest request = this.toHttpServletRequest(args);
            if (request.getDispatcherType() == DispatcherType.ASYNC || request.getDispatcherType() == DispatcherType.ERROR) {
                if (this.isDebug) {
                    this.logger.debug("Skip async servlet request event. isAsyncStarted={}, dispatcherType={}", (Object)request.isAsyncStarted(), (Object)request.getDispatcherType());
                }
                return;
            }
            this.servletRequestListenerInterceptorHelper.initialized((Object)request, JettyConstants.JETTY_METHOD, this.methodDescriptor);
        }
        catch (Throwable t) {
            this.logger.info("Failed to servlet request event handle.", t);
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        block5: {
            if (this.isDebug) {
                this.logger.afterInterceptor(target, args, result, throwable);
            }
            try {
                HttpServletRequest request = this.toHttpServletRequest(args);
                HttpServletResponse response = this.toHttpServletResponse(args);
                if (request.getDispatcherType() == DispatcherType.ASYNC || request.getDispatcherType() == DispatcherType.ERROR) {
                    if (this.isDebug) {
                        this.logger.debug("Skip async servlet request event. isAsyncStarted={}, dispatcherType={}", (Object)request.isAsyncStarted(), (Object)request.getDispatcherType());
                    }
                    return;
                }
                int statusCode = this.getStatusCode(response);
                this.servletRequestListenerInterceptorHelper.destroyed((Object)request, throwable, statusCode);
            }
            catch (Throwable t) {
                if (!this.isInfo) break block5;
                this.logger.info("Failed to servlet request event handle.", t);
            }
        }
    }

    private int getStatusCode(HttpServletResponse response) {
        try {
            return response.getStatus();
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

