/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jdbc.mariadb;

import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DefaultDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.StringMaker;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.UnKnownDatabaseInfo;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.plugin.jdbc.mariadb.MariaDBConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class MariaDBJdbcUrlParser
implements JdbcUrlParserV2 {
    private static final String MARIA_URL_PREFIX = "jdbc:mariadb:";
    private static final String MYSQL_URL_PREFIX = "jdbc:mysql:";
    private static final Set<Type> TYPES = EnumSet.allOf(Type.class);
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());

    public DatabaseInfo parse(String jdbcUrl) {
        if (jdbcUrl == null) {
            this.logger.info("jdbcUrl must not be null");
            return UnKnownDatabaseInfo.INSTANCE;
        }
        Type type = MariaDBJdbcUrlParser.getType(jdbcUrl);
        if (type == null) {
            this.logger.info("jdbcUrl has invalid prefix.(url:{}, valid prefixes:{}, {})", new Object[]{jdbcUrl, MARIA_URL_PREFIX, MYSQL_URL_PREFIX});
            return UnKnownDatabaseInfo.INSTANCE;
        }
        try {
            return this.parse0(jdbcUrl, type);
        }
        catch (Exception e) {
            this.logger.info("MaridDBJdbcUrl parse error. url: {}, Caused: {}", new Object[]{jdbcUrl, e.getMessage(), e});
            return UnKnownDatabaseInfo.createUnknownDataBase((ServiceType)MariaDBConstants.MARIADB, (ServiceType)MariaDBConstants.MARIADB_EXECUTE_QUERY, (String)jdbcUrl);
        }
    }

    private DatabaseInfo parse0(String url, Type type) {
        if (this.isLoadbalanceUrl(url, type)) {
            return this.parseLoadbalancedUrl(url, type);
        }
        return this.parseNormal(url, type);
    }

    private boolean isLoadbalanceUrl(String url, Type type) {
        String loadbalanceUrlPrefix = type.getLoadbalanceUrlPrefix();
        return url.regionMatches(true, 0, loadbalanceUrlPrefix, 0, loadbalanceUrlPrefix.length());
    }

    private DatabaseInfo parseLoadbalancedUrl(String url, Type type) {
        StringMaker maker = new StringMaker(url);
        maker.after(type.getUrlPrefix());
        String host = maker.after("//").before('/').value();
        String[] parsedHost = host.split(",");
        List<String> hostList = Arrays.asList(parsedHost);
        String databaseId = maker.next().afterLast('/').before('?').value();
        String normalizedUrl = maker.clear().before('?').value();
        return new DefaultDatabaseInfo(MariaDBConstants.MARIADB, MariaDBConstants.MARIADB_EXECUTE_QUERY, url, normalizedUrl, hostList, databaseId);
    }

    private DatabaseInfo parseNormal(String url, Type type) {
        StringMaker maker = new StringMaker(url);
        maker.after(type.getUrlPrefix());
        String host = maker.after("//").before('/').value();
        ArrayList<String> hostList = new ArrayList<String>(1);
        hostList.add(host);
        String databaseId = maker.next().afterLast('/').before('?').value();
        String normalizedUrl = maker.clear().before('?').value();
        return new DefaultDatabaseInfo(MariaDBConstants.MARIADB, MariaDBConstants.MARIADB_EXECUTE_QUERY, url, normalizedUrl, hostList, databaseId);
    }

    public ServiceType getServiceType() {
        return MariaDBConstants.MARIADB;
    }

    private static Type getType(String jdbcUrl) {
        for (Type type : TYPES) {
            if (!jdbcUrl.startsWith(type.getUrlPrefix())) continue;
            return type;
        }
        return null;
    }

    private static enum Type {
        MARIA("jdbc:mariadb:"),
        MYSQL("jdbc:mysql:");

        private final String urlPrefix;
        private final String loadbalanceUrlPrefix;

        private Type(String urlPrefix) {
            this.urlPrefix = urlPrefix;
            this.loadbalanceUrlPrefix = urlPrefix + "loadbalance:";
        }

        private String getUrlPrefix() {
            return this.urlPrefix;
        }

        private String getLoadbalanceUrlPrefix() {
            return this.loadbalanceUrlPrefix;
        }
    }
}

