/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;

class ModuleBootLoader {
    private final Instrumentation instrumentation;
    private final ClassLoader parentClassLoader;
    private Object moduleSupport;

    ModuleBootLoader(Instrumentation instrumentation, ClassLoader parentClassLoader) {
        if (instrumentation == null) {
            throw new NullPointerException("instrumentation must not be null");
        }
        this.instrumentation = instrumentation;
        this.parentClassLoader = parentClassLoader;
    }

    void loadModuleSupport() {
        try {
            Class<?> bootStrapClass = this.getModuleSupportFactoryClass(this.parentClassLoader);
            Object moduleSupportFactory = this.newModuleSupportFactory(bootStrapClass);
            Method newModuleSupportMethod = moduleSupportFactory.getClass().getMethod("newModuleSupport", Instrumentation.class);
            this.moduleSupport = newModuleSupportMethod.invoke(moduleSupportFactory, this.instrumentation);
            Class<?> moduleSupportSetup = this.moduleSupport.getClass();
            Method setupMethod = moduleSupportSetup.getMethod("setup", new Class[0]);
            setupMethod.invoke(this.moduleSupport, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("moduleSupport load fail Caused by:" + e.getMessage(), e);
        }
    }

    void defineAgentModule(ClassLoader classLoader, URL[] jarFileList) {
        if (this.moduleSupport == null) {
            throw new IllegalStateException("moduleSupport not loaded");
        }
        try {
            Method definePinpointPackage = this.moduleSupport.getClass().getDeclaredMethod("defineAgentModule", ClassLoader.class, URL[].class);
            definePinpointPackage.invoke(this.moduleSupport, classLoader, jarFileList);
        }
        catch (Exception ex) {
            throw new IllegalStateException("defineAgentPackage fail: Caused by:" + ex.getMessage(), ex);
        }
    }

    private Class<?> getModuleSupportFactoryClass(ClassLoader parentClassLoader) {
        try {
            return Class.forName("com.navercorp.pinpoint.bootstrap.java9.module.ModuleSupportFactory", false, parentClassLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("ModuleSupportFactory not found Caused by:" + ex.getMessage(), ex);
        }
    }

    private Object newModuleSupportFactory(Class<?> bootStrapClass) {
        try {
            Constructor<?> constructor = bootStrapClass.getDeclaredConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("ModuleSupportFactory() initialize fail", e);
        }
    }
}

