/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.grpc.interceptor.client;

import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.plugin.grpc.field.accessor.MethodNameAccessor;
import com.navercorp.pinpoint.plugin.grpc.field.accessor.RemoteAddressAccessor;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;

public class ChannelNewCallInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (ArrayUtils.isEmpty((Object[])args)) {
            return;
        }
        this.setMethodName(result, args[0]);
        this.setRemoteAddress(result, target);
    }

    private void setMethodName(Object result, Object methodDescriptor) {
        block7: {
            if (!(result instanceof MethodNameAccessor)) {
                if (this.isDebug) {
                    this.logger.debug("invalid result object. result:{}", result);
                }
                return;
            }
            try {
                if (methodDescriptor instanceof MethodDescriptor) {
                    String fullMethodName = ((MethodDescriptor)methodDescriptor).getFullMethodName();
                    ((MethodNameAccessor)result)._$PINPOINT$_setMethodName(fullMethodName);
                } else if (this.isDebug) {
                    this.logger.debug("invalid methodDescriptor. methodDescriptor:{}", methodDescriptor);
                }
            }
            catch (Exception e) {
                if (!this.isDebug) break block7;
                this.logger.debug("failed to invoke getFullMethodName method. caused:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void setRemoteAddress(Object result, Object channel) {
        block7: {
            if (!(result instanceof RemoteAddressAccessor)) {
                if (this.isDebug) {
                    this.logger.debug("invalid result object. result:{}", result);
                }
                return;
            }
            try {
                if (channel instanceof Channel) {
                    String remoteAddress = ((Channel)channel).authority();
                    ((RemoteAddressAccessor)result)._$PINPOINT$_setRemoteAddress(remoteAddress);
                } else if (this.isDebug) {
                    this.logger.debug("invalid channel. channel:{}", channel);
                }
            }
            catch (Exception e) {
                if (!this.isDebug) break block7;
                this.logger.debug("failed to invoke authority method. caused:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

