/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConversionException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.PropertyConverter;
import com.secnium.iast.thirdparty.org.apache.commons.lang.ClassUtils;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import java.awt.Color;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataConfiguration
extends AbstractConfiguration
implements Serializable {
    public static final String DATE_FORMAT_KEY = "com.secnium.iast.thirdparty.org.apache.commons.configuration.format.date";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final long serialVersionUID = -69011336405718640L;
    protected Configuration configuration;

    public DataConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Object getProperty(String string) {
        return this.configuration.getProperty(string);
    }

    @Override
    protected void addPropertyDirect(String string, Object object) {
        if (this.configuration instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.configuration).addPropertyDirect(string, object);
        } else {
            this.configuration.addProperty(string, object);
        }
    }

    @Override
    public void addProperty(String string, Object object) {
        this.getConfiguration().addProperty(string, object);
    }

    @Override
    public boolean isEmpty() {
        return this.configuration.isEmpty();
    }

    @Override
    public boolean containsKey(String string) {
        return this.configuration.containsKey(string);
    }

    @Override
    public void clearProperty(String string) {
        this.configuration.clearProperty(string);
    }

    @Override
    public void setProperty(String string, Object object) {
        this.configuration.setProperty(string, object);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.configuration.getKeys();
    }

    public <T> T get(Class<T> clazz, String string) {
        T t = this.get(clazz, string, null);
        if (t != null) {
            return t;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
        }
        return null;
    }

    public <T> T get(Class<T> clazz, String string, T t) {
        Object object = this.resolveContainerStore(string);
        if (object == null) {
            return t;
        }
        if (Date.class.equals(clazz) || Calendar.class.equals(clazz)) {
            return DataConfiguration.convert(clazz, string, this.interpolate(object), new String[]{this.getDefaultDateFormat()});
        }
        return DataConfiguration.convert(clazz, string, this.interpolate(object), null);
    }

    public <T> List<T> getList(Class<T> clazz, String string) {
        return this.getList(clazz, string, new ArrayList());
    }

    public <T> List<T> getList(Class<T> clazz, String string, List<T> list) {
        List<T> list2;
        Class<?> clazz2;
        Object object = this.getProperty(string);
        Class<?> clazz3 = clazz2 = object != null ? object.getClass() : null;
        if (object == null || object instanceof String && StringUtils.isEmpty((String)object)) {
            list2 = list;
        } else {
            list2 = new ArrayList<T>();
            Object[] objectArray = null;
            if (clazz.equals(Date.class) || clazz.equals(Calendar.class)) {
                objectArray = new Object[]{this.getDefaultDateFormat()};
            }
            if (clazz2.isArray()) {
                Class<?> clazz4 = clazz2.getComponentType();
                int n = Array.getLength(object);
                if (clazz4.equals(clazz) || clazz4.isPrimitive() && clazz.equals(ClassUtils.primitiveToWrapper(clazz4))) {
                    for (int i = 0; i < n; ++i) {
                        list2.add(clazz.cast(Array.get(object, i)));
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        list2.add(DataConfiguration.convert(clazz, string, this.interpolate(Array.get(object, i)), objectArray));
                    }
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                for (Object e2 : collection) {
                    list2.add(DataConfiguration.convert(clazz, string, this.interpolate(e2), objectArray));
                }
            } else {
                list2.add(DataConfiguration.convert(clazz, string, this.interpolate(object), objectArray));
            }
        }
        return list2;
    }

    public Object getArray(Class<?> clazz, String string) {
        return this.getArray(clazz, string, Array.newInstance(clazz, 0));
    }

    public Object getArray(Class<?> clazz, String string, Object object) {
        if (!(object == null || object.getClass().isArray() && clazz.isAssignableFrom(object.getClass().getComponentType()))) {
            throw new IllegalArgumentException("The type of the default value (" + object.getClass() + ")" + " is not an array of the specified class (" + clazz + ")");
        }
        if (clazz.isPrimitive()) {
            return this.getPrimitiveArray(clazz, string, object);
        }
        List<?> list = this.getList(clazz, string);
        if (list.isEmpty()) {
            return object;
        }
        return list.toArray((Object[])Array.newInstance(clazz, list.size()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getPrimitiveArray(Class<?> clazz, String string, Object object) {
        Object object2;
        Object object3 = this.getProperty(string);
        Class<?> clazz2 = object3 != null ? object3.getClass() : null;
        if (object3 == null) return object;
        if (object3 instanceof String && StringUtils.isEmpty((String)object3)) {
            return object;
        }
        if (clazz2.isArray()) {
            Class<?> clazz3 = clazz2.getComponentType();
            int n = Array.getLength(object3);
            if (clazz3.equals(clazz)) {
                return object3;
            }
            if (!clazz3.equals(ClassUtils.primitiveToWrapper(clazz))) throw new ConversionException('\'' + string + "' (" + clazz3 + ")" + " doesn't map to a compatible array of " + clazz);
            object2 = Array.newInstance(clazz, n);
            int n2 = 0;
            while (n2 < n) {
                Array.set(object2, n2, Array.get(object3, n2));
                ++n2;
            }
            return object2;
        }
        if (object3 instanceof Collection) {
            Collection collection = (Collection)object3;
            object2 = Array.newInstance(clazz, collection.size());
            int n = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                Object t = DataConfiguration.convert(ClassUtils.primitiveToWrapper(clazz), string, this.interpolate(e2), null);
                Array.set(object2, n++, t);
            }
            return object2;
        }
        Object t = DataConfiguration.convert(ClassUtils.primitiveToWrapper(clazz), string, this.interpolate(object3), null);
        object2 = Array.newInstance(clazz, 1);
        Array.set(object2, 0, t);
        return object2;
    }

    public List<Boolean> getBooleanList(String string) {
        return this.getBooleanList(string, new ArrayList<Boolean>());
    }

    public List<Boolean> getBooleanList(String string, List<Boolean> list) {
        return this.getList(Boolean.class, string, list);
    }

    public boolean[] getBooleanArray(String string) {
        return (boolean[])this.getArray(Boolean.TYPE, string);
    }

    public boolean[] getBooleanArray(String string, boolean[] blArray) {
        return (boolean[])this.getArray(Boolean.TYPE, string, blArray);
    }

    public List<Byte> getByteList(String string) {
        return this.getByteList(string, new ArrayList<Byte>());
    }

    public List<Byte> getByteList(String string, List<Byte> list) {
        return this.getList(Byte.class, string, list);
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, new byte[0]);
    }

    public byte[] getByteArray(String string, byte[] byArray) {
        return (byte[])this.getArray(Byte.TYPE, string, byArray);
    }

    public List<Short> getShortList(String string) {
        return this.getShortList(string, new ArrayList<Short>());
    }

    public List<Short> getShortList(String string, List<Short> list) {
        return this.getList(Short.class, string, list);
    }

    public short[] getShortArray(String string) {
        return this.getShortArray(string, new short[0]);
    }

    public short[] getShortArray(String string, short[] sArray) {
        return (short[])this.getArray(Short.TYPE, string, sArray);
    }

    public List<Integer> getIntegerList(String string) {
        return this.getIntegerList(string, new ArrayList<Integer>());
    }

    public List<Integer> getIntegerList(String string, List<Integer> list) {
        return this.getList(Integer.class, string, list);
    }

    public int[] getIntArray(String string) {
        return this.getIntArray(string, new int[0]);
    }

    public int[] getIntArray(String string, int[] nArray) {
        return (int[])this.getArray(Integer.TYPE, string, nArray);
    }

    public List<Long> getLongList(String string) {
        return this.getLongList(string, new ArrayList<Long>());
    }

    public List<Long> getLongList(String string, List<Long> list) {
        return this.getList(Long.class, string, list);
    }

    public long[] getLongArray(String string) {
        return this.getLongArray(string, new long[0]);
    }

    public long[] getLongArray(String string, long[] lArray) {
        return (long[])this.getArray(Long.TYPE, string, lArray);
    }

    public List<Float> getFloatList(String string) {
        return this.getFloatList(string, new ArrayList<Float>());
    }

    public List<Float> getFloatList(String string, List<Float> list) {
        return this.getList(Float.class, string, list);
    }

    public float[] getFloatArray(String string) {
        return this.getFloatArray(string, new float[0]);
    }

    public float[] getFloatArray(String string, float[] fArray) {
        return (float[])this.getArray(Float.TYPE, string, fArray);
    }

    public List<Double> getDoubleList(String string) {
        return this.getDoubleList(string, new ArrayList<Double>());
    }

    public List<Double> getDoubleList(String string, List<Double> list) {
        return this.getList(Double.class, string, list);
    }

    public double[] getDoubleArray(String string) {
        return this.getDoubleArray(string, new double[0]);
    }

    public double[] getDoubleArray(String string, double[] dArray) {
        return (double[])this.getArray(Double.TYPE, string, dArray);
    }

    public List<BigInteger> getBigIntegerList(String string) {
        return this.getBigIntegerList(string, new ArrayList<BigInteger>());
    }

    public List<BigInteger> getBigIntegerList(String string, List<BigInteger> list) {
        return this.getList(BigInteger.class, string, list);
    }

    public BigInteger[] getBigIntegerArray(String string) {
        return this.getBigIntegerArray(string, new BigInteger[0]);
    }

    public BigInteger[] getBigIntegerArray(String string, BigInteger[] bigIntegerArray) {
        return (BigInteger[])this.getArray(BigInteger.class, string, bigIntegerArray);
    }

    public List<BigDecimal> getBigDecimalList(String string) {
        return this.getBigDecimalList(string, new ArrayList<BigDecimal>());
    }

    public List<BigDecimal> getBigDecimalList(String string, List<BigDecimal> list) {
        return this.getList(BigDecimal.class, string, list);
    }

    public BigDecimal[] getBigDecimalArray(String string) {
        return this.getBigDecimalArray(string, new BigDecimal[0]);
    }

    public BigDecimal[] getBigDecimalArray(String string, BigDecimal[] bigDecimalArray) {
        return (BigDecimal[])this.getArray(BigDecimal.class, string, bigDecimalArray);
    }

    public URL getURL(String string) {
        return this.get(URL.class, string);
    }

    public URL getURL(String string, URL uRL) {
        return this.get(URL.class, string, uRL);
    }

    public List<URL> getURLList(String string) {
        return this.getURLList(string, new ArrayList<URL>());
    }

    public List<URL> getURLList(String string, List<URL> list) {
        return this.getList(URL.class, string, list);
    }

    public URL[] getURLArray(String string) {
        return this.getURLArray(string, new URL[0]);
    }

    public URL[] getURLArray(String string, URL[] uRLArray) {
        return (URL[])this.getArray(URL.class, string, uRLArray);
    }

    public Date getDate(String string) {
        return this.get(Date.class, string);
    }

    public Date getDate(String string, String string2) {
        Date date = this.getDate(string, null, string2);
        if (date != null) {
            return date;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
        }
        return null;
    }

    public Date getDate(String string, Date date) {
        return this.getDate(string, date, this.getDefaultDateFormat());
    }

    public Date getDate(String string, Date date, String string2) {
        Object object = this.resolveContainerStore(string);
        if (object == null) {
            return date;
        }
        try {
            return PropertyConverter.toDate(this.interpolate(object), string2);
        }
        catch (ConversionException conversionException) {
            throw new ConversionException('\'' + string + "' doesn't map to a Date", conversionException);
        }
    }

    public List<Date> getDateList(String string) {
        return this.getDateList(string, new ArrayList<Date>());
    }

    public List<Date> getDateList(String string, String string2) {
        return this.getDateList(string, new ArrayList<Date>(), string2);
    }

    public List<Date> getDateList(String string, List<Date> list) {
        return this.getDateList(string, list, this.getDefaultDateFormat());
    }

    public List<Date> getDateList(String string, List<Date> list, String string2) {
        List<Date> list2;
        Object object = this.getProperty(string);
        if (object == null || object instanceof String && StringUtils.isEmpty((String)object)) {
            list2 = list;
        } else if (object.getClass().isArray()) {
            list2 = new ArrayList<Date>();
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                list2.add(DataConfiguration.convert(Date.class, string, this.interpolate(Array.get(object, i)), new String[]{string2}));
            }
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            list2 = new ArrayList<Date>();
            for (Object e2 : collection) {
                list2.add(DataConfiguration.convert(Date.class, string, this.interpolate(e2), new String[]{string2}));
            }
        } else {
            list2 = new ArrayList<Date>();
            list2.add(DataConfiguration.convert(Date.class, string, this.interpolate(object), new String[]{string2}));
        }
        return list2;
    }

    public Date[] getDateArray(String string) {
        return this.getDateArray(string, new Date[0]);
    }

    public Date[] getDateArray(String string, String string2) {
        return this.getDateArray(string, new Date[0], string2);
    }

    public Date[] getDateArray(String string, Date[] dateArray) {
        return this.getDateArray(string, dateArray, this.getDefaultDateFormat());
    }

    public Date[] getDateArray(String string, Date[] dateArray, String string2) {
        List<Date> list = this.getDateList(string, string2);
        if (list.isEmpty()) {
            return dateArray;
        }
        return list.toArray(new Date[list.size()]);
    }

    public Calendar getCalendar(String string) {
        return this.get(Calendar.class, string);
    }

    public Calendar getCalendar(String string, String string2) {
        Calendar calendar = this.getCalendar(string, null, string2);
        if (calendar != null) {
            return calendar;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
        }
        return null;
    }

    public Calendar getCalendar(String string, Calendar calendar) {
        return this.getCalendar(string, calendar, this.getDefaultDateFormat());
    }

    public Calendar getCalendar(String string, Calendar calendar, String string2) {
        Object object = this.resolveContainerStore(string);
        if (object == null) {
            return calendar;
        }
        try {
            return PropertyConverter.toCalendar(this.interpolate(object), string2);
        }
        catch (ConversionException conversionException) {
            throw new ConversionException('\'' + string + "' doesn't map to a Calendar", conversionException);
        }
    }

    public List<Calendar> getCalendarList(String string) {
        return this.getCalendarList(string, new ArrayList<Calendar>());
    }

    public List<Calendar> getCalendarList(String string, String string2) {
        return this.getCalendarList(string, new ArrayList<Calendar>(), string2);
    }

    public List<Calendar> getCalendarList(String string, List<Calendar> list) {
        return this.getCalendarList(string, list, this.getDefaultDateFormat());
    }

    public List<Calendar> getCalendarList(String string, List<Calendar> list, String string2) {
        List<Calendar> list2;
        Object object = this.getProperty(string);
        if (object == null || object instanceof String && StringUtils.isEmpty((String)object)) {
            list2 = list;
        } else if (object.getClass().isArray()) {
            list2 = new ArrayList<Calendar>();
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                list2.add(DataConfiguration.convert(Calendar.class, string, this.interpolate(Array.get(object, i)), new String[]{string2}));
            }
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            list2 = new ArrayList<Calendar>();
            for (Object e2 : collection) {
                list2.add(DataConfiguration.convert(Calendar.class, string, this.interpolate(e2), new String[]{string2}));
            }
        } else {
            list2 = new ArrayList<Calendar>();
            list2.add(DataConfiguration.convert(Calendar.class, string, this.interpolate(object), new String[]{string2}));
        }
        return list2;
    }

    public Calendar[] getCalendarArray(String string) {
        return this.getCalendarArray(string, new Calendar[0]);
    }

    public Calendar[] getCalendarArray(String string, String string2) {
        return this.getCalendarArray(string, new Calendar[0], string2);
    }

    public Calendar[] getCalendarArray(String string, Calendar[] calendarArray) {
        return this.getCalendarArray(string, calendarArray, this.getDefaultDateFormat());
    }

    public Calendar[] getCalendarArray(String string, Calendar[] calendarArray, String string2) {
        List<Calendar> list = this.getCalendarList(string, string2);
        if (list.isEmpty()) {
            return calendarArray;
        }
        return list.toArray(new Calendar[list.size()]);
    }

    private String getDefaultDateFormat() {
        return this.getString(DATE_FORMAT_KEY, DEFAULT_DATE_FORMAT);
    }

    public Locale getLocale(String string) {
        return this.get(Locale.class, string);
    }

    public Locale getLocale(String string, Locale locale) {
        return this.get(Locale.class, string, locale);
    }

    public List<Locale> getLocaleList(String string) {
        return this.getLocaleList(string, new ArrayList<Locale>());
    }

    public List<Locale> getLocaleList(String string, List<Locale> list) {
        return this.getList(Locale.class, string, list);
    }

    public Locale[] getLocaleArray(String string) {
        return this.getLocaleArray(string, new Locale[0]);
    }

    public Locale[] getLocaleArray(String string, Locale[] localeArray) {
        return (Locale[])this.getArray(Locale.class, string, localeArray);
    }

    public Color getColor(String string) {
        return this.get(Color.class, string);
    }

    public Color getColor(String string, Color color) {
        return this.get(Color.class, string, color);
    }

    public List<Color> getColorList(String string) {
        return this.getColorList(string, new ArrayList<Color>());
    }

    public List<Color> getColorList(String string, List<Color> list) {
        return this.getList(Color.class, string, list);
    }

    public Color[] getColorArray(String string) {
        return this.getColorArray(string, new Color[0]);
    }

    public Color[] getColorArray(String string, Color[] colorArray) {
        return (Color[])this.getArray(Color.class, string, colorArray);
    }

    private static <T> T convert(Class<T> clazz, String string, Object object, Object[] objectArray) {
        try {
            Object object2 = PropertyConverter.to(clazz, object, objectArray);
            return clazz.cast(object2);
        }
        catch (ConversionException conversionException) {
            throw new ConversionException('\'' + string + "' doesn't map to a " + clazz, conversionException);
        }
    }
}

