/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.cli;

import com.secnium.iast.thirdparty.org.apache.commons.cli.OptionValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Option
implements Serializable,
Cloneable {
    public static final int UNINITIALIZED = -1;
    public static final int UNLIMITED_VALUES = -2;
    private static final long serialVersionUID = 1L;
    private final String opt;
    private String longOpt;
    private String argName;
    private String description;
    private boolean required;
    private boolean optionalArg;
    private int numberOfArgs = -1;
    private Class<?> type = String.class;
    private List<String> values = new ArrayList<String>();
    private char valuesep;

    private Option(Builder builder) {
        this.argName = builder.argName;
        this.description = builder.description;
        this.longOpt = builder.longOpt;
        this.numberOfArgs = builder.numberOfArgs;
        this.opt = builder.opt;
        this.optionalArg = builder.optionalArg;
        this.required = builder.required;
        this.type = builder.type;
        this.valuesep = builder.valuesep;
    }

    public Option(String string, String string2) throws IllegalArgumentException {
        this(string, null, false, string2);
    }

    public Option(String string, boolean bl, String string2) throws IllegalArgumentException {
        this(string, null, bl, string2);
    }

    public Option(String string, String string2, boolean bl, String string3) throws IllegalArgumentException {
        OptionValidator.validateOption(string);
        this.opt = string;
        this.longOpt = string2;
        if (bl) {
            this.numberOfArgs = 1;
        }
        this.description = string3;
    }

    public int getId() {
        return this.getKey().charAt(0);
    }

    String getKey() {
        return this.opt == null ? this.longOpt : this.opt;
    }

    public String getOpt() {
        return this.opt;
    }

    public Object getType() {
        return this.type;
    }

    @Deprecated
    public void setType(Object object) {
        this.setType((Class)object);
    }

    public void setType(Class<?> clazz) {
        this.type = clazz;
    }

    public String getLongOpt() {
        return this.longOpt;
    }

    public void setLongOpt(String string) {
        this.longOpt = string;
    }

    public void setOptionalArg(boolean bl) {
        this.optionalArg = bl;
    }

    public boolean hasOptionalArg() {
        return this.optionalArg;
    }

    public boolean hasLongOpt() {
        return this.longOpt != null;
    }

    public boolean hasArg() {
        return this.numberOfArgs > 0 || this.numberOfArgs == -2;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setArgName(String string) {
        this.argName = string;
    }

    public String getArgName() {
        return this.argName;
    }

    public boolean hasArgName() {
        return this.argName != null && this.argName.length() > 0;
    }

    public boolean hasArgs() {
        return this.numberOfArgs > 1 || this.numberOfArgs == -2;
    }

    public void setArgs(int n) {
        this.numberOfArgs = n;
    }

    public void setValueSeparator(char c2) {
        this.valuesep = c2;
    }

    public char getValueSeparator() {
        return this.valuesep;
    }

    public boolean hasValueSeparator() {
        return this.valuesep > '\u0000';
    }

    public int getArgs() {
        return this.numberOfArgs;
    }

    void addValueForProcessing(String string) {
        if (this.numberOfArgs == -1) {
            throw new RuntimeException("NO_ARGS_ALLOWED");
        }
        this.processValue(string);
    }

    private void processValue(String string) {
        if (this.hasValueSeparator()) {
            char c2 = this.getValueSeparator();
            int n = string.indexOf(c2);
            while (n != -1 && this.values.size() != this.numberOfArgs - 1) {
                this.add(string.substring(0, n));
                string = string.substring(n + 1);
                n = string.indexOf(c2);
            }
        }
        this.add(string);
    }

    private void add(String string) {
        if (!this.acceptsArg()) {
            throw new RuntimeException("Cannot add value, list full.");
        }
        this.values.add(string);
    }

    public String getValue() {
        return this.hasNoValues() ? null : this.values.get(0);
    }

    public String getValue(int n) throws IndexOutOfBoundsException {
        return this.hasNoValues() ? null : this.values.get(n);
    }

    public String getValue(String string) {
        String string2 = this.getValue();
        return string2 != null ? string2 : string;
    }

    public String[] getValues() {
        return this.hasNoValues() ? null : this.values.toArray(new String[this.values.size()]);
    }

    public List<String> getValuesList() {
        return this.values;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("[ option: ");
        stringBuilder.append(this.opt);
        if (this.longOpt != null) {
            stringBuilder.append(" ").append(this.longOpt);
        }
        stringBuilder.append(" ");
        if (this.hasArgs()) {
            stringBuilder.append("[ARG...]");
        } else if (this.hasArg()) {
            stringBuilder.append(" [ARG]");
        }
        stringBuilder.append(" :: ").append(this.description);
        if (this.type != null) {
            stringBuilder.append(" :: ").append(this.type);
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    private boolean hasNoValues() {
        return this.values.isEmpty();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Option option = (Option)object;
        if (this.opt != null ? !this.opt.equals(option.opt) : option.opt != null) {
            return false;
        }
        return !(this.longOpt != null ? !this.longOpt.equals(option.longOpt) : option.longOpt != null);
    }

    public int hashCode() {
        int n = this.opt != null ? this.opt.hashCode() : 0;
        n = 31 * n + (this.longOpt != null ? this.longOpt.hashCode() : 0);
        return n;
    }

    public Object clone() {
        try {
            Option option = (Option)super.clone();
            option.values = new ArrayList<String>(this.values);
            return option;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("A CloneNotSupportedException was thrown: " + cloneNotSupportedException.getMessage());
        }
    }

    void clearValues() {
        this.values.clear();
    }

    @Deprecated
    public boolean addValue(String string) {
        throw new UnsupportedOperationException("The addValue method is not intended for client use. Subclasses should use the addValueForProcessing method instead. ");
    }

    boolean acceptsArg() {
        return !(!this.hasArg() && !this.hasArgs() && !this.hasOptionalArg() || this.numberOfArgs > 0 && this.values.size() >= this.numberOfArgs);
    }

    boolean requiresArg() {
        if (this.optionalArg) {
            return false;
        }
        if (this.numberOfArgs == -2) {
            return this.values.isEmpty();
        }
        return this.acceptsArg();
    }

    public static Builder builder() {
        return Option.builder(null);
    }

    public static Builder builder(String string) {
        return new Builder(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        private final String opt;
        private String description;
        private String longOpt;
        private String argName;
        private boolean required;
        private boolean optionalArg;
        private int numberOfArgs = -1;
        private Class<?> type = String.class;
        private char valuesep;

        private Builder(String string) throws IllegalArgumentException {
            OptionValidator.validateOption(string);
            this.opt = string;
        }

        public Builder argName(String string) {
            this.argName = string;
            return this;
        }

        public Builder desc(String string) {
            this.description = string;
            return this;
        }

        public Builder longOpt(String string) {
            this.longOpt = string;
            return this;
        }

        public Builder numberOfArgs(int n) {
            this.numberOfArgs = n;
            return this;
        }

        public Builder optionalArg(boolean bl) {
            this.optionalArg = bl;
            return this;
        }

        public Builder required() {
            return this.required(true);
        }

        public Builder required(boolean bl) {
            this.required = bl;
            return this;
        }

        public Builder type(Class<?> clazz) {
            this.type = clazz;
            return this;
        }

        public Builder valueSeparator() {
            return this.valueSeparator('=');
        }

        public Builder valueSeparator(char c2) {
            this.valuesep = c2;
            return this;
        }

        public Builder hasArg() {
            return this.hasArg(true);
        }

        public Builder hasArg(boolean bl) {
            this.numberOfArgs = bl ? 1 : -1;
            return this;
        }

        public Builder hasArgs() {
            this.numberOfArgs = -2;
            return this;
        }

        public Option build() {
            if (this.opt == null && this.longOpt == null) {
                throw new IllegalArgumentException("Either opt or longOpt must be specified");
            }
            return new Option(this);
        }
    }
}

