/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.google.httpclient.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;

public class HttpRequestExecuteAsyncMethodInnerClassConstructorInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final InterceptorScope interceptorScope;

    public HttpRequestExecuteAsyncMethodInnerClassConstructorInterceptor(TraceContext traceContext, MethodDescriptor descriptor, InterceptorScope interceptorScope) {
        this.interceptorScope = interceptorScope;
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        try {
            if (!this.validate(target, args)) {
                return;
            }
            InterceptorScopeInvocation transaction = this.interceptorScope.getCurrentInvocation();
            AsyncContext asyncContext = this.getAsyncContext(transaction);
            if (asyncContext != null) {
                ((AsyncContextAccessor)target)._$PINPOINT$_setAsyncContext(asyncContext);
                transaction.removeAttachment();
            }
        }
        catch (Throwable t) {
            this.logger.warn("Failed to BEFORE process. {}", (Object)t.getMessage(), (Object)t);
        }
    }

    private AsyncContext getAsyncContext(InterceptorScopeInvocation currentInvocation) {
        Object attachment = this.getAttachment(currentInvocation);
        if (attachment instanceof AsyncContext) {
            return (AsyncContext)attachment;
        }
        return null;
    }

    private Object getAttachment(InterceptorScopeInvocation invocation) {
        if (invocation == null) {
            return null;
        }
        return invocation.getAttachment();
    }

    private boolean validate(Object target, Object[] args) {
        if (!(target instanceof AsyncContextAccessor)) {
            this.logger.debug("Invalid target object. Need field accessor({}).", (Object)AsyncContextAccessor.class.getName());
            return false;
        }
        return true;
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
    }
}

