/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.mybatis;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.plugin.mybatis.MyBatisPluginConfig;
import java.security.ProtectionDomain;
import java.util.List;

public class MyBatisPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private static final String MYBATIS_SCOPE = "MYBATIS_SCOPE";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        MyBatisPluginConfig myBatisPluginConfig = new MyBatisPluginConfig(context.getConfig());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("MyBatisPlugin config:{}", (Object)myBatisPluginConfig);
        }
        if (myBatisPluginConfig.isMyBatisEnabled()) {
            this.addInterceptorsForSqlSession();
        }
    }

    private void addInterceptorsForSqlSession() {
        String[] sqlSessionImpls;
        final MethodFilter methodFilter = MethodFilters.name((String[])new String[]{"selectOne", "selectList", "selectMap", "select", "insert", "update", "delete"});
        for (final String sqlSession : sqlSessionImpls = new String[]{"org.apache.ibatis.session.defaults.DefaultSqlSession", "org.mybatis.spring.SqlSessionTemplate"}) {
            this.transformTemplate.transform(sqlSession, new TransformCallback(){

                public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                    InstrumentClass target = instrumentor.getInstrumentClass(loader, sqlSession, classfileBuffer);
                    List methodsToTrace = target.getDeclaredMethods(methodFilter);
                    for (InstrumentMethod methodToTrace : methodsToTrace) {
                        String sqlSessionOperationInterceptor = "com.navercorp.pinpoint.plugin.mybatis.interceptor.SqlSessionOperationInterceptor";
                        methodToTrace.addScopedInterceptor(sqlSessionOperationInterceptor, MyBatisPlugin.MYBATIS_SCOPE, ExecutionPolicy.BOUNDARY);
                    }
                    return target.toBytecode();
                }
            });
        }
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

