/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.classloading;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.classloading.BootstrapCore;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjector;
import com.navercorp.pinpoint.profiler.plugin.PluginConfig;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapClassLoaderHandler
implements ClassInjector {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PluginConfig pluginConfig;
    private final BootstrapCore bootstrapCore;
    private final InstrumentEngine instrumentEngine;
    private final Object lock = new Object();
    private volatile boolean injectedToRoot = false;

    public BootstrapClassLoaderHandler(PluginConfig pluginConfig, BootstrapCore bootstrapCore, InstrumentEngine instrumentEngine) {
        this.pluginConfig = (PluginConfig)Assert.requireNonNull((Object)pluginConfig, (String)"pluginConfig must not be null");
        this.bootstrapCore = (BootstrapCore)Assert.requireNonNull((Object)bootstrapCore, (String)"bootstrapCore must not be null");
        this.instrumentEngine = (InstrumentEngine)Assert.requireNonNull((Object)instrumentEngine, (String)"instrumentEngine must not be null");
    }

    @Override
    public <T> Class<? extends T> injectClass(ClassLoader classLoader, String className) {
        if (classLoader != Object.class.getClassLoader()) {
            throw new IllegalStateException("not BootStrapClassLoader");
        }
        try {
            return this.injectClass0(className);
        }
        catch (Exception e) {
            this.logger.warn("Failed to load plugin class {} with classLoader {}", new Object[]{className, classLoader, e});
            throw new PinpointException("Failed to load plugin class " + className + " with classLoader " + classLoader, (Throwable)e);
        }
    }

    private Class<?> injectClass0(String className) throws IllegalArgumentException, ClassNotFoundException {
        this.appendToBootstrapClassLoaderSearch();
        return Class.forName(className, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToBootstrapClassLoaderSearch() {
        if (this.injectedToRoot) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.injectedToRoot) {
                this.instrumentEngine.appendToBootstrapClassPath(this.pluginConfig.getPluginJarFile());
                this.injectedToRoot = true;
            }
        }
    }

    @Override
    public InputStream getResourceAsStream(ClassLoader targetClassLoader, String internalName) {
        try {
            if (targetClassLoader == null) {
                if (this.bootstrapCore.isBootstrapPackageByInternalName(internalName)) {
                    return this.bootstrapCore.openStream(internalName);
                }
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                if (classLoader == null) {
                    return null;
                }
                this.appendToBootstrapClassLoaderSearch();
                return classLoader.getResourceAsStream(internalName);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to load plugin resource as stream {} with classLoader {}", new Object[]{internalName, targetClassLoader, e});
            return null;
        }
        this.logger.warn("Invalid bootstrap class loader. cl={}", (Object)targetClassLoader);
        return null;
    }
}

