/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient3.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.plugin.httpclient3.HostNameGetter;
import com.navercorp.pinpoint.plugin.httpclient3.HttpClient3Constants;
import com.navercorp.pinpoint.plugin.httpclient3.PortNumberGetter;
import com.navercorp.pinpoint.plugin.httpclient3.ProxyHostNameGetter;
import com.navercorp.pinpoint.plugin.httpclient3.ProxyPortNumberGetter;

public class HttpConnectionOpenMethodInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    public HttpConnectionOpenMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        super(traceContext, methodDescriptor);
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
        recorder.recordApi(this.methodDescriptor);
        recorder.recordServiceType(HttpClient3Constants.HTTP_CLIENT_3_INTERNAL);
        if (target instanceof HostNameGetter && target instanceof PortNumberGetter && target instanceof ProxyHostNameGetter && target instanceof ProxyPortNumberGetter) {
            String hostAndPort = this.getHostAndPort(target);
            recorder.recordAttribute(AnnotationKey.HTTP_INTERNAL_DISPLAY, hostAndPort);
        }
    }

    private String getHostAndPort(Object target) {
        if (((ProxyHostNameGetter)target)._$PINPOINT$_getProxyHostName() != null) {
            String host = ((ProxyHostNameGetter)target)._$PINPOINT$_getProxyHostName();
            int port = ((ProxyPortNumberGetter)target)._$PINPOINT$_getProxyPortNumber();
            return HostAndPort.toHostAndPortString((String)host, (int)port);
        }
        String host = ((HostNameGetter)target)._$PINPOINT$_getHostName();
        int port = ((PortNumberGetter)target)._$PINPOINT$_getPortNumber();
        return HostAndPort.toHostAndPortString((String)host, (int)port);
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        recorder.recordException(throwable);
    }
}

