/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.undertow;

import com.navercorp.pinpoint.bootstrap.config.ExcludeMethodFilter;
import com.navercorp.pinpoint.bootstrap.config.ExcludePathFilter;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.SkipFilter;
import java.util.List;

public class UndertowConfig {
    private final boolean enable;
    private final List<String> bootstrapMains;
    private final boolean hidePinpointHeader;
    private final boolean traceRequestParam;
    private final Filter<String> excludeUrlFilter;
    private final String realIpHeader;
    private final String realIpEmptyValue;
    private final Filter<String> excludeProfileMethodFilter;
    private final boolean deployServlet;

    public UndertowConfig(ProfilerConfig config) {
        if (config == null) {
            throw new NullPointerException("config must not be null");
        }
        this.enable = config.readBoolean("profiler.undertow.enable", true);
        this.deployServlet = config.readBoolean("profiler.undertow.deploy.servlet", true);
        this.bootstrapMains = config.readList("profiler.undertow.bootstrap.main");
        this.hidePinpointHeader = config.readBoolean("profiler.undertow.hidepinpointheader", true);
        this.traceRequestParam = config.readBoolean("profiler.undertow.tracerequestparam", true);
        String tomcatExcludeURL = config.readString("profiler.undertow.excludeurl", "");
        this.excludeUrlFilter = !tomcatExcludeURL.isEmpty() ? new ExcludePathFilter(tomcatExcludeURL) : new SkipFilter();
        this.realIpHeader = config.readString("profiler.undertow.realipheader", null);
        this.realIpEmptyValue = config.readString("profiler.undertow.realipemptyvalue", null);
        String tomcatExcludeProfileMethod = config.readString("profiler.undertow.excludemethod", "");
        this.excludeProfileMethodFilter = !tomcatExcludeProfileMethod.isEmpty() ? new ExcludeMethodFilter(tomcatExcludeProfileMethod) : new SkipFilter();
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isDeployServlet() {
        return this.deployServlet;
    }

    public List<String> getBootstrapMains() {
        return this.bootstrapMains;
    }

    public boolean isHidePinpointHeader() {
        return this.hidePinpointHeader;
    }

    public boolean isTraceRequestParam() {
        return this.traceRequestParam;
    }

    public Filter<String> getExcludeUrlFilter() {
        return this.excludeUrlFilter;
    }

    public String getRealIpHeader() {
        return this.realIpHeader;
    }

    public String getRealIpEmptyValue() {
        return this.realIpEmptyValue;
    }

    public Filter<String> getExcludeProfileMethodFilter() {
        return this.excludeProfileMethodFilter;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UndertowConfig{");
        sb.append("enable=").append(this.enable);
        sb.append(", bootstrapMains=").append(this.bootstrapMains);
        sb.append(", hidePinpointHeader=").append(this.hidePinpointHeader);
        sb.append(", traceRequestParam=").append(this.traceRequestParam);
        sb.append(", excludeUrlFilter=").append(this.excludeUrlFilter);
        sb.append(", realIpHeader='").append(this.realIpHeader).append('\'');
        sb.append(", realIpEmptyValue='").append(this.realIpEmptyValue).append('\'');
        sb.append(", excludeProfileMethodFilter=").append(this.excludeProfileMethodFilter);
        sb.append('}');
        return sb.toString();
    }
}

