/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.tomcat.interceptor;

import com.navercorp.pinpoint.bootstrap.context.ServerMetaDataHolder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import org.apache.catalina.connector.Connector;

public class ConnectorInitializeInterceptor
implements AroundInterceptor {
    private PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private TraceContext traceContext;

    public ConnectorInitializeInterceptor(TraceContext traceContext) {
        this.traceContext = traceContext;
    }

    public void before(Object target, Object[] args) {
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (target instanceof Connector) {
            Connector connector = (Connector)target;
            ServerMetaDataHolder holder = this.traceContext.getServerMetaDataHolder();
            holder.addConnector(connector.getProtocol(), connector.getPort());
            holder.notifyListeners();
        }
    }
}

