/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.interceptor.annotation.Scope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.profiler.instrument.ScopeInfo;

public class ScopeFactory {
    public ScopeInfo newScopeInfo(ClassLoader classLoader, InstrumentContext pluginContext, String interceptorClassName, InterceptorScope scope, ExecutionPolicy policy) {
        Class interceptorClass;
        Scope scopeAnnotation;
        if (scope == null && (scopeAnnotation = (interceptorClass = pluginContext.injectClass(classLoader, interceptorClassName)).getAnnotation(Scope.class)) != null) {
            return this.newScopeInfoByAnnotation(pluginContext, scopeAnnotation);
        }
        policy = this.getExecutionPolicy(scope, policy);
        return new ScopeInfo(scope, policy);
    }

    private ScopeInfo newScopeInfoByAnnotation(InstrumentContext pluginContext, Scope scope) {
        String scopeName = scope.value();
        InterceptorScope interceptorScope = pluginContext.getInterceptorScope(scopeName);
        ExecutionPolicy policy = scope.executionPolicy();
        return new ScopeInfo(interceptorScope, policy);
    }

    private ExecutionPolicy getExecutionPolicy(InterceptorScope scope, ExecutionPolicy policy) {
        if (scope == null) {
            policy = null;
        } else if (policy == null) {
            policy = ExecutionPolicy.BOUNDARY;
        }
        return policy;
    }
}

