/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.interceptor.registry.InterceptorRegistry;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorDefinition;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.lang.reflect.Modifier;

public class InvokeCodeGenerator {
    protected final ApiMetaDataService apiMetaDataService;
    protected final InterceptorDefinition interceptorDefinition;
    protected final InstrumentMethod targetMethod;
    protected final int interceptorId;

    public InvokeCodeGenerator(int interceptorId, InterceptorDefinition interceptorDefinition, InstrumentMethod targetMethod, ApiMetaDataService apiMetaDataService) {
        if (interceptorDefinition == null) {
            throw new NullPointerException("interceptorDefinition must not be null");
        }
        if (targetMethod == null) {
            throw new NullPointerException("targetMethod must not be null");
        }
        if (apiMetaDataService == null) {
            throw new NullPointerException("apiMetaDataService must not be null");
        }
        this.interceptorDefinition = interceptorDefinition;
        this.targetMethod = targetMethod;
        this.interceptorId = interceptorId;
        this.apiMetaDataService = apiMetaDataService;
    }

    protected String getInterceptorType() {
        return this.interceptorDefinition.getInterceptorBaseClass().getName();
    }

    protected String getParameterTypes() {
        String[] parameterTypes = this.targetMethod.getParameterTypes();
        return JavaAssistUtils.getParameterDescription(parameterTypes);
    }

    protected String getTarget() {
        return Modifier.isStatic(this.targetMethod.getModifiers()) ? "null" : "this";
    }

    protected String getArguments() {
        if (this.targetMethod.getParameterTypes().length == 0) {
            return "null";
        }
        return "$args";
    }

    protected int getApiId() {
        MethodDescriptor descriptor = this.targetMethod.getDescriptor();
        int apiId = this.apiMetaDataService.cacheApi(descriptor);
        return apiId;
    }

    protected String getInterceptorRegistryClassName() {
        return InterceptorRegistry.class.getName();
    }

    protected String getInterceptorVar() {
        return InvokeCodeGenerator.getInterceptorVar(this.interceptorId);
    }

    public static String getInterceptorVar(int interceptorId) {
        return "_$PINPOINT$_interceptor" + interceptorId;
    }
}

