/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.context.AsyncTraceId;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.context.AsyncTraceContext;
import com.navercorp.pinpoint.profiler.context.BaseTraceFactory;
import com.navercorp.pinpoint.profiler.context.Binder;
import com.navercorp.pinpoint.profiler.context.DefaultLocalAsyncId;
import com.navercorp.pinpoint.profiler.context.DefaultReference;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.Reference;
import com.navercorp.pinpoint.profiler.context.id.AsyncIdGenerator;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.id.TraceRootSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncTraceContext
implements AsyncTraceContext {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Reference<Trace> EMPTY = DefaultReference.emptyReference();
    private final AsyncIdGenerator asyncIdGenerator;
    private Provider<BaseTraceFactory> baseTraceFactoryProvider;
    private final Binder<Trace> binder;

    public DefaultAsyncTraceContext(Provider<BaseTraceFactory> baseTraceFactoryProvider, AsyncIdGenerator asyncIdGenerator, Binder<Trace> binder) {
        this.baseTraceFactoryProvider = (Provider)Assert.requireNonNull(baseTraceFactoryProvider, (String)"baseTraceFactoryProvider must not be null");
        this.asyncIdGenerator = (AsyncIdGenerator)Assert.requireNonNull((Object)asyncIdGenerator, (String)"asyncIdGenerator must not be null");
        this.binder = (Binder)Assert.requireNonNull(binder, (String)"binder must not be null");
    }

    @Override
    public Reference<Trace> continueAsyncTraceObject(TraceRoot traceRoot, LocalAsyncId localAsyncId) {
        Reference<Trace> reference = this.checkAndGet();
        BaseTraceFactory baseTraceFactory = (BaseTraceFactory)this.baseTraceFactoryProvider.get();
        Trace trace = baseTraceFactory.continueAsyncTraceObject(traceRoot, localAsyncId);
        this.bind(reference, trace);
        return reference;
    }

    @Override
    public Trace newAsyncTraceObject(TraceRoot traceRoot, LocalAsyncId localAsyncId) {
        BaseTraceFactory baseTraceFactory = (BaseTraceFactory)this.baseTraceFactoryProvider.get();
        return baseTraceFactory.continueAsyncTraceObject(traceRoot, localAsyncId);
    }

    @Override
    public Reference<Trace> continueAsyncTraceObject(AsyncTraceId asyncTraceId, int asyncId, long startTime) {
        Assert.requireNonNull((Object)asyncTraceId, (String)"asyncTraceId must not be null");
        TraceRoot traceRoot = this.getTraceRoot(asyncTraceId, startTime);
        short asyncSequence = asyncTraceId.nextAsyncSequence();
        DefaultLocalAsyncId localAsyncId = new DefaultLocalAsyncId(asyncId, asyncSequence);
        return this.continueAsyncTraceObject(traceRoot, localAsyncId);
    }

    @Override
    public Reference<Trace> currentRawTraceObject() {
        Reference<Trace> reference = this.binder.get();
        return reference;
    }

    @Override
    public Reference<Trace> currentTraceObject() {
        Reference<Trace> reference = this.binder.get();
        Trace trace = reference.get();
        if (trace == null) {
            return EMPTY;
        }
        if (trace.canSampled()) {
            return reference;
        }
        return EMPTY;
    }

    @Override
    public void removeTraceObject() {
        this.binder.remove();
    }

    private TraceRoot getTraceRoot(AsyncTraceId asyncTraceId, long startTime) {
        if (asyncTraceId instanceof TraceRootSupport) {
            TraceRoot traceRoot = ((TraceRootSupport)asyncTraceId).getTraceRoot();
            this.assertTraceStartTime(traceRoot, startTime);
            return traceRoot;
        }
        throw new UnsupportedOperationException("unsupported TraceRootSupport:" + asyncTraceId);
    }

    private void assertTraceStartTime(TraceRoot traceRoot, long startTime) {
        if (traceRoot.getTraceStartTime() != startTime) {
            throw new IllegalStateException("traceStartTime not equals traceRoot:" + traceRoot.getTraceStartTime() + " startTime:" + startTime);
        }
    }

    private Reference<Trace> checkAndGet() {
        Reference<Trace> reference = this.binder.get();
        Trace old = reference.get();
        if (old != null) {
            PinpointException exception = new PinpointException("already Trace Object exist.");
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("beforeTrace:{}", (Object)old, (Object)exception);
            }
            throw exception;
        }
        return reference;
    }

    private void bind(Reference<Trace> reference, Trace trace) {
        reference.set(trace);
    }

    @Override
    public int nextAsyncId() {
        return this.asyncIdGenerator.nextAsyncId();
    }
}

