/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.lambda;

import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import com.navercorp.pinpoint.profiler.instrument.lambda.LambdaClass;
import com.navercorp.pinpoint.profiler.instrument.lambda.LambdaClassJava8;
import com.navercorp.pinpoint.profiler.instrument.lambda.LambdaClassJava9;
import com.navercorp.pinpoint.profiler.instrument.lambda.MethodInstReplacer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaFactoryClassAdaptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String lambdaFactoryClassName = "java/lang/invoke/InnerClassLambdaMetafactory";
    private static final String lambdaFactoryMethodName = "spinInnerClass";

    public byte[] loadTransformedBytecode(byte[] bytes) {
        LambdaClass lambdaClass = this.getLambdaClass();
        return this.transform(bytes, lambdaClass);
    }

    private LambdaClass getLambdaClass() {
        if (JvmUtils.getVersion().onOrAfter(JvmVersion.JAVA_9)) {
            return new LambdaClassJava9();
        }
        return new LambdaClassJava8();
    }

    public byte[] transform(byte[] bytes, LambdaClass lambdaClass) {
        if (bytes == null) {
            throw new NullPointerException("bytes must not be null");
        }
        ClassReader reader = new ClassReader(bytes);
        ClassWriter writer = new ClassWriter(reader, 2);
        String unsafeClass = lambdaClass.getUnsafeClass();
        String unsafeMethod = lambdaClass.getUnsafeMethod();
        String delegateClassName = lambdaClass.getDelegateClass();
        String delegateMethodName = lambdaClass.getDelegateMethod();
        MethodInstReplacer methodInstReplacer = new MethodInstReplacer((ClassVisitor)writer, lambdaFactoryMethodName, unsafeClass, unsafeMethod, delegateClassName, delegateMethodName);
        reader.accept((ClassVisitor)methodInstReplacer, 0);
        if (!lambdaFactoryClassName.equals(methodInstReplacer.getClassName())) {
            throw new IllegalArgumentException("unexpected class " + methodInstReplacer.getClassName());
        }
        if (methodInstReplacer.getTransformCount() != 1) {
            this.logger.warn("unexpected {}.{} invoke count {}", new Object[]{unsafeClass, unsafeMethod, methodInstReplacer.getTransformCount()});
        }
        return writer.toByteArray();
    }
}

