/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor;

import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.plugin.rabbitmq.client.field.accessor.LocalAddressAccessor;
import com.navercorp.pinpoint.plugin.rabbitmq.client.field.accessor.RemoteAddressAccessor;
import java.net.Socket;

public class SocketFrameHandlerConstructInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());

    public void before(Object target, Object[] args) {
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (!this.validate(target, args)) {
            return;
        }
        String localAddress = "Unknown";
        String remoteAddress = "Unknown";
        if (args[0] instanceof Socket) {
            Socket socket = (Socket)args[0];
            localAddress = HostAndPort.toHostAndPortString((String)socket.getLocalAddress().getHostAddress(), (int)socket.getLocalPort());
            remoteAddress = HostAndPort.toHostAndPortString((String)socket.getInetAddress().getHostAddress(), (int)socket.getPort());
        }
        ((LocalAddressAccessor)target)._$PINPOINT$_setLocalAddress(localAddress);
        ((RemoteAddressAccessor)target)._$PINPOINT$_setRemoteAddress(remoteAddress);
    }

    private boolean validate(Object target, Object[] args) {
        if (args == null || args.length < 1) {
            return false;
        }
        if (!(target instanceof LocalAddressAccessor)) {
            this.logger.debug("Invalid target object. Need field accessor({})", (Object)LocalAddressAccessor.class.getName());
            return false;
        }
        if (!(target instanceof RemoteAddressAccessor)) {
            this.logger.debug("Invalid target object. Need field accessor({})", (Object)RemoteAddressAccessor.class.getName());
            return false;
        }
        return true;
    }
}

