/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.hystrix;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.instrument.ClassFilter;
import com.navercorp.pinpoint.bootstrap.instrument.ClassFilters;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.BasicMethodInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.rxjava.transformer.SchedulerWorkerTransformCallback;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.hystrix.HystrixPluginConfig;
import com.navercorp.pinpoint.plugin.hystrix.HystrixPluginConstants;
import com.navercorp.pinpoint.plugin.hystrix.field.HystrixKeyNameAccessor;
import java.security.ProtectionDomain;

public class HystrixPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        HystrixPluginConfig config = new HystrixPluginConfig(context.getConfig());
        if (config.isTraceHystrix()) {
            this.addHystrixCommandTransformers();
            this.addHystrixMetricsTransformers();
            this.addTransformersForTimeoutsInObservables();
            this.addHystrixContextSchedulerWorkerScheduleTransformers();
        }
    }

    private void addHystrixCommandTransformers() {
        this.transformTemplate.transform("com.netflix.hystrix.HystrixCommand", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod getFallbackOrThrowException;
                InstrumentMethod getFallbackObservable;
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"execute", "queue"}))) {
                    method.addScopedInterceptor("com.navercorp.pinpoint.plugin.hystrix.interceptor.HystrixCommandInterceptor", "HystrixCommandExecutionScope", ExecutionPolicy.BOUNDARY);
                }
                InstrumentMethod getExecutionObservable = target.getDeclaredMethod("getExecutionObservable", new String[0]);
                if (getExecutionObservable != null) {
                    getExecutionObservable.addScopedInterceptor(BasicMethodInterceptor.class.getName(), VarArgs.va((Object[])new Object[]{HystrixPluginConstants.HYSTRIX_INTERNAL_SERVICE_TYPE}), "HystrixCommandExecutionScope", ExecutionPolicy.ALWAYS);
                }
                if ((getFallbackObservable = target.getDeclaredMethod("getFallbackObservable", new String[0])) != null) {
                    getFallbackObservable.addScopedInterceptor(BasicMethodInterceptor.class.getName(), VarArgs.va((Object[])new Object[]{HystrixPluginConstants.HYSTRIX_INTERNAL_SERVICE_TYPE}), "HystrixCommandExecutionScope", ExecutionPolicy.ALWAYS);
                }
                if ((getFallbackOrThrowException = target.getDeclaredMethod("getFallbackOrThrowException", new String[]{"com.netflix.hystrix.HystrixEventType", "com.netflix.hystrix.exception.HystrixRuntimeException$FailureType", "java.lang.String", "java.lang.Exception"})) != null) {
                    getFallbackOrThrowException.addScopedInterceptor("com.navercorp.pinpoint.plugin.hystrix.interceptor.HystrixCommandGetFallbackOrThrowExceptionArgs4Interceptor", "HystrixCommandExecutionScope", ExecutionPolicy.ALWAYS);
                }
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("com.netflix.hystrix.HystrixObservableCommand", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod getFallbackObservable;
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod getExecutionObservable = target.getDeclaredMethod("getExecutionObservable", new String[0]);
                if (getExecutionObservable != null) {
                    getExecutionObservable.addScopedInterceptor(BasicMethodInterceptor.class.getName(), VarArgs.va((Object[])new Object[]{HystrixPluginConstants.HYSTRIX_INTERNAL_SERVICE_TYPE}), "HystrixCommandExecutionScope", ExecutionPolicy.ALWAYS);
                }
                if ((getFallbackObservable = target.getDeclaredMethod("getFallbackObservable", new String[0])) != null) {
                    getFallbackObservable.addScopedInterceptor(BasicMethodInterceptor.class.getName(), VarArgs.va((Object[])new Object[]{HystrixPluginConstants.HYSTRIX_INTERNAL_SERVICE_TYPE}), "HystrixCommandExecutionScope", ExecutionPolicy.ALWAYS);
                }
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("com.netflix.hystrix.AbstractCommand", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"observe", "toObservable"}))) {
                    method.addScopedInterceptor("com.navercorp.pinpoint.plugin.hystrix.interceptor.HystrixCommandInterceptor", "HystrixCommandExecutionScope");
                }
                InstrumentMethod getFallbackOrThrowException = target.getDeclaredMethod("getFallbackOrThrowException", new String[]{"com.netflix.hystrix.AbstractCommand", "com.netflix.hystrix.HystrixEventType", "com.netflix.hystrix.exception.HystrixRuntimeException$FailureType", "java.lang.String", "java.lang.Exception"});
                if (getFallbackOrThrowException != null) {
                    getFallbackOrThrowException.addScopedInterceptor("com.navercorp.pinpoint.plugin.hystrix.interceptor.HystrixCommandGetFallbackOrThrowExceptionArgs5Interceptor", "HystrixCommandExecutionScope", ExecutionPolicy.ALWAYS);
                } else {
                    getFallbackOrThrowException = target.getDeclaredMethod("getFallbackOrThrowException", new String[]{"com.netflix.hystrix.HystrixEventType", "com.netflix.hystrix.exception.HystrixRuntimeException$FailureType", "java.lang.String", "java.lang.Exception"});
                    if (getFallbackOrThrowException != null) {
                        getFallbackOrThrowException.addScopedInterceptor("com.navercorp.pinpoint.plugin.hystrix.interceptor.HystrixCommandGetFallbackOrThrowExceptionArgs4Interceptor", "HystrixCommandExecutionScope", ExecutionPolicy.ALWAYS);
                    }
                }
                return target.toBytecode();
            }
        });
    }

    private void addHystrixMetricsTransformers() {
        this.transformTemplate.transform("com.netflix.hystrix.HystrixCommandMetrics", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod constructor = target.getConstructor(new String[]{"com.netflix.hystrix.HystrixCommandKey", "com.netflix.hystrix.HystrixCommandGroupKey", "com.netflix.hystrix.HystrixThreadPoolKey", "com.netflix.hystrix.HystrixCommandProperties", "com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier"});
                if (constructor == null) {
                    constructor = target.getConstructor(new String[]{"com.netflix.hystrix.HystrixCommandKey", "com.netflix.hystrix.HystrixCommandGroupKey", "com.netflix.hystrix.HystrixCommandProperties", "com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier"});
                }
                if (constructor == null) {
                    return null;
                }
                constructor.addInterceptor("com.navercorp.pinpoint.plugin.hystrix.interceptor.metrics.HystrixCommandMetricsConstructInterceptor");
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("com.netflix.hystrix.HystrixCircuitBreaker$HystrixCircuitBreakerImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod constructor = target.getConstructor(new String[]{"com.netflix.hystrix.HystrixCommandKey", "com.netflix.hystrix.HystrixCommandGroupKey", "com.netflix.hystrix.HystrixCommandProperties", "com.netflix.hystrix.HystrixCommandMetrics"});
                if (constructor == null) {
                    return null;
                }
                constructor.addInterceptor("com.navercorp.pinpoint.plugin.hystrix.interceptor.metrics.HystrixCircuitBreakerConstructInterceptor");
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("com.netflix.hystrix.HystrixThreadPoolMetrics", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod constructor = target.getConstructor(new String[]{"com.netflix.hystrix.HystrixThreadPoolKey", "java.util.concurrent.ThreadPoolExecutor", "com.netflix.hystrix.HystrixThreadPoolProperties"});
                if (constructor == null) {
                    return null;
                }
                constructor.addInterceptor("com.navercorp.pinpoint.plugin.hystrix.interceptor.metrics.HystrixThreadPoolMetricsConstructInterceptor");
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("com.netflix.hystrix.HystrixCollapserMetrics", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod constructor = target.getConstructor(new String[]{"com.netflix.hystrix.HystrixCollapserKey", "com.netflix.hystrix.HystrixCollapserProperties"});
                if (constructor == null) {
                    return null;
                }
                constructor.addInterceptor("com.navercorp.pinpoint.plugin.hystrix.interceptor.metrics.HystrixCollapserMetricsConstructInterceptor");
                return target.toBytecode();
            }
        });
        TransformCallback hystrixKeyTransformCallback = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod constructor = target.getConstructor(new String[]{"java.lang.String"});
                if (constructor == null) {
                    return null;
                }
                target.addField(HystrixKeyNameAccessor.class.getName());
                constructor.addInterceptor("com.navercorp.pinpoint.plugin.hystrix.interceptor.metrics.HystrixKeyConstructInterceptor");
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("com.netflix.hystrix.HystrixCommandKey$Factory$HystrixCommandKeyDefault", hystrixKeyTransformCallback);
        this.transformTemplate.transform("com.netflix.hystrix.HystrixCommandGroupKey$Factory$HystrixCommandGroupDefault", hystrixKeyTransformCallback);
        this.transformTemplate.transform("com.netflix.hystrix.HystrixThreadPoolKey$Factory$HystrixThreadPoolKeyDefault", hystrixKeyTransformCallback);
        this.transformTemplate.transform("com.netflix.hystrix.HystrixCollapserKey$Factory$HystrixCollapserKeyDefault", hystrixKeyTransformCallback);
    }

    private void addTransformersForTimeoutsInObservables() {
        this.transformTemplate.transform("com.netflix.hystrix.AbstractCommand$HystrixObservableTimeoutOperator", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod call = target.getDeclaredMethod("call", new String[]{"rx.Subscriber"});
                if (call == null) {
                    return null;
                }
                target.addField(AsyncContextAccessor.class.getName());
                call.addInterceptor("com.navercorp.pinpoint.plugin.hystrix.interceptor.HystrixObservableTimeoutOperatorCallInterceptor");
                for (InstrumentClass nested : target.getNestedClasses(ClassFilters.chain((ClassFilter[])new ClassFilter[]{ClassFilters.interfaze((String[])new String[]{"com.netflix.hystrix.util.HystrixTimer$TimerListener"}), ClassFilters.enclosingMethod((String)"call", (String[])new String[]{"rx.Subscriber"})}))) {
                    instrumentor.transform(classLoader, nested.getName(), new TransformCallback(){

                        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                            InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                            InstrumentMethod constructor = target.getConstructor(new String[]{"com.netflix.hystrix.AbstractCommand$HystrixObservableTimeoutOperator", "rx.subscriptions.CompositeSubscription", "com.netflix.hystrix.strategy.concurrency.HystrixRequestContext", "rx.Subscriber"});
                            if (constructor == null) {
                                constructor = target.getConstructor(new String[]{"com.netflix.hystrix.AbstractCommand$HystrixObservableTimeoutOperator", "rx.subscriptions.CompositeSubscription", "com.netflix.hystrix.strategy.concurrency.HystrixContextRunnable"});
                            }
                            InstrumentMethod tick = target.getDeclaredMethod("tick", new String[0]);
                            if (constructor == null || tick == null) {
                                return null;
                            }
                            target.addField("com.navercorp.pinpoint.plugin.hystrix.field.EnclosingInstanceAccessor");
                            constructor.addInterceptor("com.navercorp.pinpoint.plugin.hystrix.interceptor.HystrixObservableTimeoutListenerConstructorInterceptor");
                            tick.addInterceptor("com.navercorp.pinpoint.plugin.hystrix.interceptor.HystrixObservableTimeoutListenerTickInterceptor");
                            return target.toBytecode();
                        }
                    });
                }
                return target.toBytecode();
            }
        });
    }

    private void addHystrixContextSchedulerWorkerScheduleTransformers() {
        SchedulerWorkerTransformCallback callback = SchedulerWorkerTransformCallback.createFor((ServiceType)HystrixPluginConstants.HYSTRIX_INTERNAL_SERVICE_TYPE);
        this.transformTemplate.transform("com.netflix.hystrix.strategy.concurrency.HystrixContextScheduler$HystrixContextSchedulerWorker", (TransformCallback)callback);
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

