/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient4;

import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestWrapper;
import com.navercorp.pinpoint.common.util.Assert;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;

public class HttpClient4RequestWrapper
implements ClientRequestWrapper {
    private final HttpRequest httpRequest;
    private final String hostName;
    private final int port;

    public HttpClient4RequestWrapper(HttpRequest httpRequest, String hostName, int port) {
        this.httpRequest = (HttpRequest)Assert.requireNonNull((Object)httpRequest, (String)"httpRequest must not be null");
        this.hostName = hostName;
        this.port = port;
    }

    public String getDestinationId() {
        return HttpClient4RequestWrapper.getEndpoint(this.hostName, this.port);
    }

    private static String getEndpoint(String host, int port) {
        if (host == null) {
            return "Unknown";
        }
        if (port < 0) {
            return host;
        }
        StringBuilder sb = new StringBuilder(host.length() + 8);
        sb.append(host);
        sb.append(':');
        sb.append(port);
        return sb.toString();
    }

    public String getUrl() {
        RequestLine requestLine = this.httpRequest.getRequestLine();
        if (requestLine != null) {
            return requestLine.getUri();
        }
        return null;
    }
}

