/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.common.util.PinpointThreadFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioClientBossPool;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.Timer;

public class ClientChannelFactory {
    public ChannelFactory createChannelFactory(int bossCount, int workerCount, Timer timer) {
        ExecutorService boss = this.newCachedThreadPool("Pinpoint-Client-Boss");
        NioClientBossPool bossPool = new NioClientBossPool((Executor)boss, bossCount, timer, ThreadNameDeterminer.CURRENT);
        ExecutorService worker = this.newCachedThreadPool("Pinpoint-Client-Worker");
        NioWorkerPool workerPool = new NioWorkerPool((Executor)worker, workerCount, ThreadNameDeterminer.CURRENT);
        return new NioClientSocketChannelFactory((BossPool)bossPool, (WorkerPool)workerPool);
    }

    private ExecutorService newCachedThreadPool(String threadName) {
        PinpointThreadFactory threadFactory = new PinpointThreadFactory(threadName, true);
        return Executors.newCachedThreadPool((ThreadFactory)threadFactory);
    }
}

