/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.classloading;

import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.classloading.BootstrapClassLoaderHandler;
import com.navercorp.pinpoint.profiler.instrument.classloading.BootstrapCore;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjector;
import com.navercorp.pinpoint.profiler.instrument.classloading.PlainClassLoaderHandler;
import com.navercorp.pinpoint.profiler.instrument.classloading.URLClassLoaderHandler;
import com.navercorp.pinpoint.profiler.plugin.PluginConfig;
import java.io.InputStream;
import java.net.URLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarProfilerPluginClassInjector
implements ClassInjector {
    private final Logger logger = LoggerFactory.getLogger(JarProfilerPluginClassInjector.class);
    private final ClassInjector bootstrapClassLoaderHandler;
    private final ClassInjector urlClassLoaderHandler;
    private final ClassInjector plainClassLoaderHandler;

    public JarProfilerPluginClassInjector(PluginConfig pluginConfig, InstrumentEngine instrumentEngine, BootstrapCore bootstrapCore) {
        if (pluginConfig == null) {
            throw new NullPointerException("pluginConfig must not be null");
        }
        this.bootstrapClassLoaderHandler = new BootstrapClassLoaderHandler(pluginConfig, bootstrapCore, instrumentEngine);
        this.urlClassLoaderHandler = new URLClassLoaderHandler(pluginConfig, bootstrapCore);
        this.plainClassLoaderHandler = new PlainClassLoaderHandler(pluginConfig, bootstrapCore);
    }

    @Override
    public <T> Class<? extends T> injectClass(ClassLoader classLoader, String className) {
        try {
            if (classLoader == null) {
                return this.bootstrapClassLoaderHandler.injectClass(null, className);
            }
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                return this.urlClassLoaderHandler.injectClass(urlClassLoader, className);
            }
            return this.plainClassLoaderHandler.injectClass(classLoader, className);
        }
        catch (Throwable e) {
            this.logger.warn("Failed to load plugin class {} with classLoader {}", new Object[]{className, classLoader, e});
            throw new PinpointException("Failed to load plugin class " + className + " with classLoader " + classLoader, e);
        }
    }

    @Override
    public InputStream getResourceAsStream(ClassLoader targetClassLoader, String internalName) {
        try {
            if (targetClassLoader == null) {
                return this.bootstrapClassLoaderHandler.getResourceAsStream(null, internalName);
            }
            if (targetClassLoader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)targetClassLoader;
                return this.urlClassLoaderHandler.getResourceAsStream(urlClassLoader, internalName);
            }
            return this.plainClassLoaderHandler.getResourceAsStream(targetClassLoader, internalName);
        }
        catch (Throwable e) {
            this.logger.warn("Failed to load plugin resource as stream {} with classLoader {}", new Object[]{internalName, targetClassLoader, e});
            return null;
        }
    }
}

