/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.metric.buffer;

import com.navercorp.pinpoint.profiler.monitor.metric.buffer.BufferMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.buffer.BufferMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.buffer.BufferType;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.ObjectName;

public class DefaultBufferMetric
implements BufferMetric {
    private final BufferPoolMXBean direct;
    private final BufferPoolMXBean mapped;

    public DefaultBufferMetric() {
        List<BufferPoolMXBean> pools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        this.direct = this.getBufferPool(pools, BufferType.DIRECT.getName());
        this.mapped = this.getBufferPool(pools, BufferType.MAPPED.getName());
    }

    private BufferPoolMXBean getBufferPool(List<BufferPoolMXBean> pools, String type) {
        for (BufferPoolMXBean pool : pools) {
            String poolName = pool.getName();
            if (!poolName.equals(type)) continue;
            return pool;
        }
        return new EmptyBufferPoolMXBean();
    }

    public BufferMetricSnapshot getSnapshot() {
        long directCount = this.direct.getCount();
        long directMemoryUsed = this.direct.getMemoryUsed();
        long mappedCount = this.mapped.getCount();
        long mappedMemoryUsed = this.mapped.getMemoryUsed();
        return new BufferMetricSnapshot(directCount, directMemoryUsed, mappedCount, mappedMemoryUsed);
    }

    public String toString() {
        return "DefaultBufferMetric";
    }

    private static class EmptyBufferPoolMXBean
    implements BufferPoolMXBean {
        private EmptyBufferPoolMXBean() {
        }

        @Override
        public ObjectName getObjectName() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public long getCount() {
            return -1L;
        }

        @Override
        public long getTotalCapacity() {
            return -1L;
        }

        @Override
        public long getMemoryUsed() {
            return -1L;
        }
    }
}

