/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import java.security.ProtectionDomain;

public class GuardInstrumentor
implements Instrumentor {
    private final ProfilerConfig profilerConfig;
    private final InstrumentContext instrumentContext;
    private boolean closed = false;

    public GuardInstrumentor(ProfilerConfig profilerConfig, InstrumentContext instrumentContext) {
        if (profilerConfig == null) {
            throw new NullPointerException("profilerConfig must not be null");
        }
        if (instrumentContext == null) {
            throw new NullPointerException("instrumentContext must not be null");
        }
        this.profilerConfig = profilerConfig;
        this.instrumentContext = instrumentContext;
    }

    public ProfilerConfig getProfilerConfig() {
        return this.profilerConfig;
    }

    public InstrumentClass getInstrumentClass(ClassLoader classLoader, String className, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        this.checkOpen();
        return this.instrumentContext.getInstrumentClass(classLoader, className, protectionDomain, classfileBuffer);
    }

    public InstrumentClass getInstrumentClass(ClassLoader classLoader, String className, byte[] classfileBuffer) {
        this.checkOpen();
        return this.instrumentContext.getInstrumentClass(classLoader, className, null, classfileBuffer);
    }

    public boolean exist(ClassLoader classLoader, String className, ProtectionDomain protectionDomain) {
        this.checkOpen();
        return this.instrumentContext.exist(classLoader, className, protectionDomain);
    }

    public boolean exist(ClassLoader classLoader, String className) {
        this.checkOpen();
        return this.instrumentContext.exist(classLoader, className, null);
    }

    public InterceptorScope getInterceptorScope(String scopeName) {
        this.checkOpen();
        return this.instrumentContext.getInterceptorScope(scopeName);
    }

    public <T> Class<? extends T> injectClass(ClassLoader targetClassLoader, String className) {
        this.checkOpen();
        return this.instrumentContext.injectClass(targetClassLoader, className);
    }

    public void transform(ClassLoader classLoader, String targetClassName, TransformCallback transformCallback) {
        this.checkOpen();
        this.instrumentContext.addClassFileTransformer(classLoader, targetClassName, transformCallback);
    }

    public void retransform(Class<?> target, TransformCallback transformCallback) {
        this.checkOpen();
        this.instrumentContext.retransform(target, transformCallback);
    }

    public void close() {
        this.closed = true;
    }

    private void checkOpen() {
        if (this.closed) {
            throw new IllegalStateException("Instrumentor already closed");
        }
    }
}

