/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.cxf;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.cxf.CxfPluginConfig;
import com.navercorp.pinpoint.plugin.cxf.CxfPluginConstants;
import java.security.ProtectionDomain;

public class CxfPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        CxfPluginConfig config = new CxfPluginConfig(context.getConfig());
        if (config.isServiceProfile()) {
            this.addCxfService();
        }
        if (config.isLoggingProfile()) {
            this.addCxfLogging();
        }
        if (config.isClientProfile()) {
            this.addCxfClient();
        }
    }

    private void addCxfService() {
        this.transformTemplate.transform("org.apache.cxf.interceptor.ServiceInvokerInterceptor", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod handleMessageMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"handleMessage", (String[])new String[]{"org.apache.cxf.message.Message"});
                handleMessageMethod.addInterceptor("com.navercorp.pinpoint.bootstrap.interceptor.BasicMethodInterceptor", VarArgs.va((Object[])new Object[]{CxfPluginConstants.CXF_SERVICE_INVOKER_SERVICE_TYPE}));
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("org.apache.cxf.interceptor.MessageSenderInterceptor", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod handleMessageMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"handleMessage", (String[])new String[]{"org.apache.cxf.message.Message"});
                handleMessageMethod.addInterceptor("com.navercorp.pinpoint.bootstrap.interceptor.BasicMethodInterceptor", VarArgs.va((Object[])new Object[]{CxfPluginConstants.CXF_MESSAGE_SENDER_SERVICE_TYPE}));
                return target.toBytecode();
            }
        });
    }

    private void addCxfLogging() {
        this.transformTemplate.transform("org.apache.cxf.interceptor.LoggingInInterceptor", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod formatLoggingMessage = InstrumentUtils.findMethod((InstrumentClass)target, (String)"formatLoggingMessage", (String[])new String[]{"org.apache.cxf.interceptor.LoggingMessage"});
                formatLoggingMessage.addScopedInterceptor("com.navercorp.pinpoint.plugin.cxf.interceptor.CxfLoggingInMessageMethodInterceptor", "CXF_SCOPE");
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("org.apache.cxf.interceptor.LoggingOutInterceptor", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod formatLoggingMessage = InstrumentUtils.findMethod((InstrumentClass)target, (String)"formatLoggingMessage", (String[])new String[]{"org.apache.cxf.interceptor.LoggingMessage"});
                formatLoggingMessage.addScopedInterceptor("com.navercorp.pinpoint.plugin.cxf.interceptor.CxfLoggingOutMessageMethodInterceptor", "CXF_SCOPE");
                return target.toBytecode();
            }
        });
    }

    @Deprecated
    private void addCxfClient() {
        this.transformTemplate.transform("org.apache.cxf.frontend.ClientProxy", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod invokeSyncMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"invokeSync", (String[])new String[]{"java.lang.reflect.Method", "org.apache.cxf.service.model.BindingOperationInfo", "java.lang.Object[]"});
                invokeSyncMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.cxf.interceptor.CxfClientInvokeSyncMethodInterceptor", "CxfClientScope");
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("org.apache.cxf.interceptor.MessageSenderInterceptor$MessageSenderEndingInterceptor", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod handleMessageMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"handleMessage", (String[])new String[]{"org.apache.cxf.message.Message"});
                handleMessageMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.cxf.interceptor.CxfClientHandleMessageMethodInterceptor", "CxfClientScope");
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

