/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.metadata;

import com.navercorp.pinpoint.bootstrap.context.ParsingResult;
import com.navercorp.pinpoint.common.util.DefaultSqlParser;
import com.navercorp.pinpoint.common.util.NormalizedSql;
import com.navercorp.pinpoint.common.util.SqlParser;
import com.navercorp.pinpoint.profiler.metadata.CachingSqlNormalizer;
import com.navercorp.pinpoint.profiler.metadata.DefaultParsingResult;
import com.navercorp.pinpoint.profiler.metadata.ParsingResultInternal;
import com.navercorp.pinpoint.profiler.metadata.Result;
import com.navercorp.pinpoint.profiler.metadata.SimpleCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCachingSqlNormalizer
implements CachingSqlNormalizer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final DefaultParsingResult EMPTY_OBJECT = new DefaultParsingResult("");
    private final SimpleCache<String> sqlCache;
    private final SqlParser sqlParser;

    public DefaultCachingSqlNormalizer(int cacheSize) {
        this.sqlCache = new SimpleCache(cacheSize);
        this.sqlParser = new DefaultSqlParser();
    }

    @Override
    public ParsingResult wrapSql(String sql) {
        if (sql == null) {
            return EMPTY_OBJECT;
        }
        return new DefaultParsingResult(sql);
    }

    @Override
    public boolean normalizedSql(ParsingResult parsingResult) {
        if (parsingResult == null) {
            return false;
        }
        if (parsingResult == EMPTY_OBJECT) {
            return false;
        }
        if (parsingResult.getId() != 0) {
            return false;
        }
        if (!(parsingResult instanceof ParsingResultInternal)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("unsupported ParsingResult Type type {}", (Object)parsingResult);
            }
            throw new IllegalArgumentException("unsupported ParsingResult Type");
        }
        ParsingResultInternal parsingResultInternal = (ParsingResultInternal)parsingResult;
        String originalSql = parsingResultInternal.getOriginalSql();
        NormalizedSql normalizedSql = this.sqlParser.normalizedSql(originalSql);
        Result cachingResult = this.sqlCache.put(normalizedSql.getNormalizedSql());
        boolean success = parsingResultInternal.setId(cachingResult.getId());
        if (!success && this.logger.isWarnEnabled()) {
            this.logger.warn("invalid state. setSqlId fail setId:{}, ParsingResultInternal:{}", (Object)cachingResult.getId(), (Object)parsingResultInternal);
        }
        parsingResultInternal.setSql(normalizedSql.getNormalizedSql());
        parsingResultInternal.setOutput(normalizedSql.getParseParameter());
        return cachingResult.isNewValue();
    }
}

