/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.transformer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;

public class HierarchyCaches {
    private static final int MAX = 64;
    private LoadingCache<String, Hierarchy> caches;
    private final boolean active;
    private int cacheSize = 8;
    private int cacheEntrySize = 8;

    public HierarchyCaches(int size, int entrySize) {
        if (size <= 0) {
            this.active = false;
            return;
        }
        this.active = true;
        this.cacheSize = size > 64 ? 64 : size;
        this.cacheEntrySize = entrySize <= 0 ? this.cacheSize : (entrySize > 64 ? 64 : entrySize);
        this.caches = CacheBuilder.newBuilder().maximumSize((long)this.cacheSize).initialCapacity(this.cacheSize).concurrencyLevel(4).build((CacheLoader)new CacheLoader<String, Hierarchy>(){

            public Hierarchy load(String s) throws Exception {
                return new Hierarchy();
            }
        });
    }

    public boolean get(String key, String classInternalName) {
        if (!this.active) {
            return false;
        }
        try {
            return ((Hierarchy)this.caches.get((Object)key)).cache.getIfPresent((Object)classInternalName) != null;
        }
        catch (ExecutionException executionException) {
            return false;
        }
    }

    public void put(String key, String classInternalName) {
        if (!this.active) {
            return;
        }
        try {
            ((Hierarchy)this.caches.get((Object)key)).cache.put((Object)classInternalName, (Object)Boolean.TRUE);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("caches=").append(this.caches.asMap()).append(", ");
        sb.append("size=").append(this.caches.size()).append(", ");
        sb.append("stats=").append(this.caches.stats());
        sb.append("}");
        return sb.toString();
    }

    class Hierarchy {
        Cache<String, Boolean> cache;

        public Hierarchy() {
            this.cache = CacheBuilder.newBuilder().maximumSize((long)HierarchyCaches.this.cacheEntrySize).initialCapacity(HierarchyCaches.this.cacheEntrySize).concurrencyLevel(4).build();
        }

        public String toString() {
            return this.cache.asMap().keySet().toString();
        }
    }
}

