/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.thrift;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaData;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaData;
import com.navercorp.pinpoint.profiler.metadata.StringMetaData;
import com.navercorp.pinpoint.thrift.dto.TApiMetaData;
import com.navercorp.pinpoint.thrift.dto.TSqlMetaData;
import com.navercorp.pinpoint.thrift.dto.TStringMetaData;
import org.apache.thrift.TBase;

public class MetadataMessageConverter
implements MessageConverter<TBase<?, ?>> {
    private final String applicationName;
    private final String agentId;
    private final long agentStartTime;

    public MetadataMessageConverter(String applicationName, String agentId, long agentStartTime) {
        this.applicationName = (String)Assert.requireNonNull((Object)applicationName, (String)"applicationName must not be null");
        this.agentId = (String)Assert.requireNonNull((Object)agentId, (String)"agentId must not be null");
        this.agentStartTime = agentStartTime;
    }

    @Override
    public TBase<?, ?> toMessage(Object message) {
        if (message instanceof SqlMetaData) {
            SqlMetaData sqlMetaData = (SqlMetaData)message;
            return new TSqlMetaData(this.agentId, this.agentStartTime, sqlMetaData.getSqlId(), sqlMetaData.getSql());
        }
        if (message instanceof ApiMetaData) {
            ApiMetaData apiMetaData = (ApiMetaData)message;
            TApiMetaData tApiMetaData = new TApiMetaData(this.agentId, this.agentStartTime, apiMetaData.getApiId(), apiMetaData.getApiInfo());
            tApiMetaData.setLine(apiMetaData.getLine());
            tApiMetaData.setType(apiMetaData.getType());
            return tApiMetaData;
        }
        if (message instanceof StringMetaData) {
            StringMetaData stringMetaData = (StringMetaData)message;
            return new TStringMetaData(this.agentId, this.agentStartTime, stringMetaData.getStringId(), stringMetaData.getStringValue());
        }
        return null;
    }
}

