/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.recorder;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.util.AnnotationKeyUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.StringMetaDataService;

public abstract class AbstractRecorder {
    protected final StringMetaDataService stringMetaDataService;
    protected final SqlMetaDataService sqlMetaDataService;

    public AbstractRecorder(StringMetaDataService stringMetaDataService, SqlMetaDataService sqlMetaDataService) {
        if (stringMetaDataService == null) {
            throw new NullPointerException("stringMetaDataService must not be null");
        }
        if (sqlMetaDataService == null) {
            throw new NullPointerException("sqlMetaDataService must not be null");
        }
        this.stringMetaDataService = stringMetaDataService;
        this.sqlMetaDataService = sqlMetaDataService;
    }

    public void recordError() {
        this.maskErrorCode(1);
    }

    public void recordException(Throwable throwable) {
        this.recordException(true, throwable);
    }

    public void recordException(boolean markError, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        String drop = StringUtils.abbreviate((String)throwable.getMessage(), (int)256);
        int exceptionId = this.stringMetaDataService.cacheString(throwable.getClass().getName());
        this.setExceptionInfo(exceptionId, drop);
        if (markError) {
            this.recordError();
        }
    }

    abstract void setExceptionInfo(int var1, String var2);

    abstract void maskErrorCode(int var1);

    public void recordApi(MethodDescriptor methodDescriptor) {
        if (methodDescriptor == null) {
            return;
        }
        if (methodDescriptor.getApiId() == 0) {
            this.recordAttribute(AnnotationKey.API, methodDescriptor.getFullName());
        } else {
            this.setApiId0(methodDescriptor.getApiId());
        }
    }

    public void recordApi(MethodDescriptor methodDescriptor, Object[] args) {
        this.recordApi(methodDescriptor);
        this.recordArgs(args);
    }

    public void recordApi(MethodDescriptor methodDescriptor, Object args, int index) {
        this.recordApi(methodDescriptor);
        this.recordSingleArg(args, index);
    }

    public void recordApi(MethodDescriptor methodDescriptor, Object[] args, int start, int end) {
        this.recordApi(methodDescriptor);
        this.recordArgs(args, start, end);
    }

    public void recordApiCachedString(MethodDescriptor methodDescriptor, String args, int index) {
        this.recordApi(methodDescriptor);
        this.recordSingleCachedString(args, index);
    }

    abstract void setApiId0(int var1);

    private void recordArgs(Object[] args, int start, int end) {
        if (args != null) {
            int max = Math.min(Math.min(args.length, 10), end);
            for (int i = start; i < max; ++i) {
                this.recordAttribute(AnnotationKeyUtils.getArgs((int)i), args[i]);
            }
        }
    }

    private void recordSingleArg(Object args, int index) {
        if (args != null) {
            this.recordAttribute(AnnotationKeyUtils.getArgs((int)index), args);
        }
    }

    private void recordSingleCachedString(String args, int index) {
        if (args != null) {
            int cacheId = this.stringMetaDataService.cacheString(args);
            this.recordAttribute(AnnotationKeyUtils.getCachedArgs((int)index), cacheId);
        }
    }

    private void recordArgs(Object[] args) {
        if (args != null) {
            int max = Math.min(args.length, 10);
            for (int i = 0; i < max; ++i) {
                this.recordAttribute(AnnotationKeyUtils.getArgs((int)i), args[i]);
            }
        }
    }

    public void recordAttribute(AnnotationKey key, String value) {
        Annotation annotation = new Annotation(key.getCode(), value);
        this.addAnnotation(annotation);
    }

    public void recordAttribute(AnnotationKey key, int value) {
        Annotation annotation = new Annotation(key.getCode(), value);
        this.addAnnotation(annotation);
    }

    public void recordAttribute(AnnotationKey key, Object value) {
        Annotation annotation = new Annotation(key.getCode(), value);
        this.addAnnotation(annotation);
    }

    abstract void addAnnotation(Annotation var1);
}

