/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.rpc.util.TimerFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class SpanStatConnectTimerProvider
implements Provider<Timer> {
    private final ProfilerConfig profilerConfig;

    @Inject
    public SpanStatConnectTimerProvider(ProfilerConfig profilerConfig) {
        this.profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig must not be null");
    }

    public Timer get() {
        if ("TCP".equalsIgnoreCase(this.profilerConfig.getSpanDataSenderTransportType()) || "TCP".equalsIgnoreCase(this.profilerConfig.getStatDataSenderTransportType())) {
            return SpanStatConnectTimerProvider.createTimer("Pinpoint-SpanStatConnect-Timer");
        }
        return null;
    }

    private static Timer createTimer(String timerName) {
        HashedWheelTimer timer = TimerFactory.createHashedWheelTimer((String)timerName, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS, (int)512);
        timer.start();
        return timer;
    }
}

